.TH Target 5 "SUN-3/e" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: SUN-3/E
.SH BOOTING
.PP
The SUN-3/E has only 64k of ROM space, and
VxWorks boot ROMs require a minimum of 128k to function.
Therefore, SUN's booting scheme is used to bring up VxWorks.
The main restriction with this is that a SUN-3/E can only be booted from a
SUN host and only the SUN-3/E ethernet board can be used.
Note that no EPROM booting devices are supplied,
and that the VxWorks boot parameters display and boot ROM commands
explained in the \f2Getting Started\f1 section will not be used.
.PP
SUN monitor boot ROMs use TFTP (trivial file transfer protocol).
With this protocol, the internet address is determined
from the ethernet address using RARP,
instead of the standard procedure where the user types in
the internet address to the VxWorks boot ROMs.
This requires that the target's 6-byte ethernet address be determined first.
.PP
Follow the steps below to boot VxWorks on the SUN-3/E:
.IP (1)
Verify that the SUN-3/E is properly plugged into the cage
with the SUN-3/E ethernet card.
Refer to the hardware configuration section of \f2Getting Started\f1 and
the notes below on jumpering the SUN-3/E for proper setup.
Note particularly that VxWorks uses port A on the SUN-3/E
as its console device,
and that this port is a null modem (pins 2 and 3 crossed).
.IP (2)
Determine the ethernet address of your target SUN-3/E.
The simplest way to do this is boot the SUN-3/E,
and watch for the ethernet address displayed in the initial banner.
After recording the address,
abort the boot by typing the L1 function key and A simultaneously,
or press \s-1BREAK\s0 if using a standard terminal port
instead of a SUN console.
.IP (3)
On the host machine, add a line to \f3/etc/ethers\f1,
assigning a target name to the ethernet address.
For example, the line:
.CS
    8:0:20:0:d4:1d  phobos
.CE
designates ``phobos'' as the chosen name for a target SUN-3/E whose ethernet
address is 8:0:20:0:d4:1d.
.IP (4)
As with the standard procedure,
add a line to \f3/etc/hosts\f1,
assigning an internet address for the target machine.
For example:
.CS
    90.0.0.50  phobos
.CE
designates 90.0.0.50 as the chosen internet address for the target ``phobos''.
.IP
Also add the target name to \f3/etc/hosts.equiv\f1 if it is to be permitted
remote login, command execution, and file access on the host.
If remote requests are to have root privileges,
also add the line to \f3/etc/.rhosts\f1.
.IP (5)
Check that the RARP daemon is running on the host machine by typing:
.CS
    ps -aux | grep rarpd
.CE
If it is not running, start it up by typing:
.CS
    rarpd ie0 hostname &
.CE
The network device name is generally ``ie0'',
it may vary if your network system has a different configuration.
.IP
An entry for \f3rarpd\f1 should be added to \f3/etc/rc.local\f1
so that it will automatically be re-initialized
whenever the host is re-booted.
.IP (6)
Determine the hexadecimal equivalent of the internet address.
For example, 90.0.0.50 would equal 5A000032.
One quick way to get the hex name at this stage is to again boot the SUN-3/E
by typing ``b ie()'' to its boot ROMs (or powering it up again);
it will display the file it's looking for.
Abort the boot as explained in (1) above.
.IP (7)
If the VxWorks system files have not already been installed on
the host system as explained in \f2Getting Started\f1,
now is the time to do so.
Create a symbolic link between the VxWorks executable \f3vxWorks.b\f1
and a file with the name which is the hex equivalent
of the internet address as determined above.
This file should be located in the directory \f3/tftpboot\f1.
For example:
.CS
    ln -s /usr/vw/config/sun3e/vxWorks.b /tftpboot/5A000032
.CE
The \f3.b\f1 version
is a special pure-executable required by the SUN-3/E;
it has the 32-bit header already stripped.
.IP
Be sure that \f3vxWorks.b\f1 and all levels of its directory path
have global read privileges.
Use \f3chmod 755\f1 to change the permissions.
.IP (8)
Non-Standard Installation:
By default, VxWorks always looks in the standard installation directory
\f3/usr/vw/config/sun3e\f1 for its symbol table, \f3vxWorks.sym\f1.
If you install \f3vxWorks.b\f1 or the symbol table elsewhere, you
must edit the bootline in \f3config.h\f1 to reflect this, and then
recompile \f3vxWorks.b\f1.
The line to change in \f3config.h\f1 is:
.CS
    #define DEFAULT_BOOT_LINE ... pathname ...
.CE
Edit the \f2pathname\f1 specification to show where you have
installed VxWorks.  Then remake VxWorks:
.CS
    make vxWorks.b
.CE
.IP (9)
Once these steps are completed, you are ready to boot VxWorks.
Boot by typing:
.CS
    b ie()
.CE
to the SUN-3/E boot ROMs, or powering it up from scratch.

.SH JUMPERING
.PP
The relevant SUN-3/E jumper is listed below.
Use the supplied \f3jump (4)\f1 program to determine the exact jumper
configuration for both the SUN-3/E and the \f3ie\f1 ethernet board.
All jumpers not mentioned should be left at factory setting.
The \s-1DIAG/NORM\s0 switch should be set to \s-1NORM\s0.

.IP JB300*
This jumper block determines which VMEbus interrupts the CPU will respond to.
It should be set to respond to the interrupt required by the network board.

.SH DEVICES
.PP
VxWorks supplies a terminal driver for the on-board serial port
which is set up to drive ports A, B, and the keyboard.
The device is created in \f3/usr/vw/config/all/usrConfig.c\f1
and is named ``/tyCo/0''.
The mouse channel is not available because its baud rate generator
drives the auxiliary clock.
.SH SPECIAL CONSIDERATIONS
.PP
The SUN-3/E cannot change the location of its dual-ported RAM in VME space.
It can only dual port 1Mb of its 4Mb.
.PP
The SUN-3/E uses a number of lines on the P2(a,c) bus which may conflict
with other CPU's.
A number of vendors use these buses as high-speed memory buses to their own
memory boards.
It is desirable to work in a chassis that does not bus P2(a,c) so that it
can be bussed at the discretion of the user.
.PP
To get back to the SUN-3/E monitor, issue a \s-1CTRL-X\s0.
Memory is not cleared during a reboot,
so application debugging is still possible.
.PP
Although the SUN-3/E has 4Mb of RAM, VxWorks uses only the lower three.
The SUN boot ROMs use the top 1Mb.
If an application needs more memory and the \s-1CTRL-X\s+1 facility
is not needed, \f2sysMemTop (2)\fP can be changed to return 4Mb.
