.TH Target 5 "MZ8115" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: Mizar MZ8115
.SH BOOTING
.PP
The MZ8115 uses the standard VxWorks two ROM set.
The odd ROM (labeled LB) goes in socket U12,
and the even ROM (labeled HB) goes in U11.
The file bootrom.hex contains the S-record of the bootrom.
Follow the instructions in the ``Getting Started'' chapter to load VxWorks.
.SH "JUMPERING"
.PP
The following jumpers must be changed from the factory defaults.
Consult the MZ8115 manual for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.

.CS
.nf
K1  - parity            - disabled
K2  - IACK daisy chain  - default
K3  - ROM configuration - configure for 64K * 8 devices,
                          and interrupt levels set for network
                          board as appropriate.
K4  - bus timeout       - remove to disable.
K5  - system controller - install if board is to be system
                          controller (factory default).
                          NOTE that there must be only one
                          system controller on the back plane
                          and it must be in the first slot.
K6  - bus arbitration   - round-robin
K7  - bus request level - default (level 0)
K8  - bus grant level   - default (level 0)
K9  - BCLR              - disabled
.fi
.CE

.SH "DEVICES"
.PP
VxWorks supplies a driver for the two on-board serial ports.
The device is created in usrConfig.c, named "/tyCo/0".
A second device is created called "/tyCo/1".
.PP
The MZ8115 also supports several daughter cards.
Contact Mizar for availability of drivers such as those for
the MZ7810 Dual Serial/Single Parallel card,
the MZ7820 VSB card, and the MZ7830 SCSI card.
 

.SH "NETWORK BOARD JUMPERING"
.PP
This CPU works with all VxWorks network drivers.
.CS
.nf
  BOARD           IO-ADRS
 -------         ---------
 Excelan 202      0x7f0000
 CMC ENP-10       0xde0000
 ISI nw           0x780000
.fi
.CE

See the network board jumpering section for
each board's interrupt level and configuration details.

.SH "SPECIAL CONSIDERATIONS"
.PP
The RS232 ports on the MZ8115 are brought out on two header pin connectors.
The console device ("/tyCo/0") comes out the front of the board;
the other ("/tyCo/1") comes directly off the side of the board itself.
The pinout of these connector is listed in section 3.6 of the
MZ8115 User's Manual (Mizar part number MZ-78115-MN).
A set of cables to connect each connector to a DB25-type connector
is available from Mizar, as part number MZ-8115-CB.  Note, however, that
pins 4 and 5 (RTS and CTS respectively) are swapped on the header pin
connectors; they are also swapped as brought out on the cables.
If using RTS/CTS these two lines need to swapped.
.PP
The MZ8115 has a feature unique in the VMEbus world: a "side card" connector
that allows the addition of a side card, which brings the board to a full
6U size.  Several different configurations of I/O options are provided by
standard Mizar boards, such as the MZ8830 or MZ8840.
Alternatively, Mizar can provide a wire-wrapped side card
(part number MZ-8802), and/or in addition can provide custom side cards. 
.PP
For those applications that require multiple CPUs on the same VMEbus, there
are two considerations.  By default, VxWorks expects to have
64 Kbytes of external RAM available at address 0x800000 to conduct backplane
polling.  Second, if more than one of the CPUs are MZ8115s, PAL U10 will have
to be changed on at least all but one of the boards to prevent address
conflicts.  Mizar has a standard set of alternate U10 PALs (part numbers
271001 to 271028) which can remap the RAM into any available A24 address;
see appendix D of your MZ8115 hardware manual.
.PP
Both the above addresses are software reconfigurable as BP_ANCHOR_ADRS and
LOCAL_MEM_BUS_ADRS; see file config.h for further comments.
.PP
This board responds in 24 bit address space only as there is no P2 bus.

.SH "INTERRUPT STRUCTURE"
.PP
VMEbus interrupts IRQ1 through IRQ7 are connected directly to the CPU.
They are enabled by jumpering as above, and interrupt the CPU at their
respective actual interrupt levels.  These interrupts are vectored by the
vector number put on the bus by the interrupting device, and are automatically
acknowledged by the MZ8115 hardware.  In addition, BCLR may be enabled at
level 5, auto-vectored; however, in VxWorks the default mode for this board
is release-on-request, so the BCLR interrupt is not used.  In fact, in the
current VxWorks code, if a BCLR interrupt is executed, the board is forced
back to release-on-request (see sysALib.s).

MZ8115 INTERRUPT STRUCTURE: ON-BOARD INTERRUPTS
.PP
The on-board interrupt levels are fixed as follows:
.CS
.nf
ABORT switch         level 7
sidecard SIRQ 1      level 6
BCLR interrupt       level 5
sidecard SIRQ 2      level 4
m68681 - serial      level 3
.fi
.CE
.PP
The on-board interrupts are autovectored (with the exception of the
m68681, set to user interrupt 64 (40 hex) ); they are automatically
acknowledged by the hardware.
MZ8115 MEMORY MAP -- as seen from the CPU
.CS
.nf
00 0000   07 FFFF       DPRAM
08 0000   EF FFFF       VMEbus A24 space
F0 0000   F7 FFFF       (Reserved for side card functions)
F8 0000   F9 FFFF       EPROM
FA 0000   FE 7FFF       (Reserved for side card functions)
FE 8001   FE FFFF       m68681 DUART, odd bytes only
FF 0000   FF FFFF       VMEbus A16 space
.fi
.CE
MZ8115 MEMORY MAP -- as seen from the VMEbus
.CS
.nf
XXE8 0000   EF FFFF       DPRAM
.fi
.CE
.PP
This board responds in 24 bit address space only as there is no P2 bus.

.SH "TECHNICAL SUPPORT"
.PP
Contact Mizar Digital Systems Technical Support Center at (214) 446-2664.
