.TH sysLocalToBusAdrs 2 "Mizar MZ8115" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLocalToBusAdrs - convert local address to bus address
.SH SYNOPSIS
.CS
.nf
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
    int adrsSpace;   /* bus address space in which busAdrs resides;
                      * use address modifier codes as defined in vme.h,
                      * such as VME_AM_STD_SUP_DATA */
    char *localAdrs; /* local address to convert */
    char **pBusAdrs; /* where to return bus address */
.fi
.CE
.SH DESCRIPTION
Given a local memory address, this routine returns the VMEbus address
that would have to be accessed to get to that byte.

.SH NOTE MZ8115
In A24 space, only the lower 24 address bits are examined.  In A16 space,
only the lower 16 address bits are examined.  Unused bits are set to zeros
on exit.

.SH RETURNS
 OK, or ERROR if unable to get to that local address from the VMEbus.

.SH SEE ALSO
sysLib(1),
sysBusToLocalAdrs (2)
