.TH sysLib 1 "Mizar MZ7122" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLib.c - Mizar mz7122 and mz7124 system dependent library 
.SH SYNOPSIS
.nf
sysModel - return model name of the system CPU
sysHwInit - initialize hardware
sysMemTop - get top of memory address
sysToMonitor - transfer to rom monitor
sysClkConnect - connect routine to system clock interrupt
sysClkDisable - turn off system clock interrupts
sysClkEnable - turn system clock interrupts on
sysClkRateGet - get rate of system clock
sysClkRateSet - set rate of system clock
sysAuxClkConnect - connect a routine to the auxiliary clock interrupt
sysAuxClkDisconnect - clear the auxiliary clock routine
sysAuxClkDisable - turn off auxiliary clock interrupts
sysAuxClkEnable - turn auxiliary clock interrupts on
sysAuxClkRateGet - get the auxiliary timer frequency
sysAuxClkRateSet - set rate of auxiliary clock
sysLocalToBusAdrs - convert local address to bus address
sysBusToLocalAdrs - convert bus address to local address
sysIntDisable - disable VMEbus interrupt level
sysIntEnable - enable VMEbus interrupt level
sysBusIntAck - acknowledge VMEbus interrupt
sysBusIntGen - generate VMEbus interrupt
sysMailboxConnect - connect routine to the mailbox interrupt
sysMailboxEnable - enable mailbox interrupt
sysProcNumGet - get processor number
sysProcNumSet - set processor number
sysBusTas - test and set across VMEbus
sysMailboxAddressSet - set mailbox address as determined by sysProcNum.
sysMailboxAddressGet - get currently defined mailbox address.
sysBCLInit - set initial values of both board control latches
sysBCLGet - return the current value of the board control latch
sysBCLSet - set bits in the board control latch
sysM562Connect - set interrupt routines for the mz7122/24 DUSCC
sysFrontPanelSwitches - read DIP switches

char *sysModel ()
VOID sysHwInit ()
char *sysMemTop ()
STATUS sysToMonitor (startType)
STATUS sysClkConnect (routine, arg)
VOID sysClkDisable ()
VOID sysClkEnable ()
int sysClkRateGet ()
VOID sysClkRateSet (ticksPerSecond)
STATUS sysAuxClkConnect (routine, arg)
VOID sysAuxClkDisconnect ()
VOID sysAuxClkDisable ()
VOID sysAuxClkEnable ()
int sysAuxClkRateGet ()
VOID sysAuxClkRateSet (ticksPerSecond)
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
STATUS sysBusToLocalAdrs (adrsSpace, busAdrs, pLocalAdrs)
STATUS sysIntDisable (intLevel)
STATUS sysIntEnable (intLevel)
STATUS sysBusIntAck (intLevel)
STATUS sysBusIntGen (intLevel, intVector)
STATUS sysMailboxConnect (routine, arg)
STATUS sysMailboxEnable (mailboxAdrs)
int sysProcNumGet ()
VOID sysProcNumSet (procNum)
BOOL sysBusTas (addr)
int sysMailboxAddressSet ()
int sysMailboxAddressGet ()
VOID sysBCLInit ()
STATUS sysBCLGet (latchNum)
VOID sysBCLSet (mask, value, latchNum)
STATUS sysM562Connect (recvRoutine, xmitRoutine)
int sysFrontPanelSwitches ()
.fi
.SH DESCRIPTION
This library contains a set of routines to manipulate the primary functions
of the CPU board.  The goal is to provide a board-independant interface on
which VxWorks and application code can be built in a system-independant way.
Not every feature of every board is supported by this library; a particular
board may have various extensions to the capabilities described here.
Also not every board will support all the functions provided by this library.
And some boards provide some of the functions of this library with hardware
switches, jumpers, or PALs, instead of software controllable registers.

The funtions addressed here include:

    initialization functions:
        - initialize hardware to known state
        - identify the system

    memory/address space functions:
        - get on-board memory limit
        - map from local to bus and bus to local address spaces
        - enable/disable cache memory
        - set/get non-volatile RAM

    bus interrupt functions:
        - enable/disable bus interrupt levels
        - generate bus interrupts
          
    serial channel functions (see tyCoDrv):
        - enable/disable serial channel interrupts
        - set serial channel baud rates
        - get/put bytes from a serial channel
                                       
    clock/timer functions:
        - enable/disable timer interrupts
        - set timer periodic rate

    mailbox/location monitor functions:
        - enable mailbox/location monitor interrupts

