.TH sysBCLSet 2 "Mizar MZ7122" "VxWorks Reference Manual"
.ad b
.SH NAME
sysBCLSet - set bits in the board control latch
.SH SYNOPSIS
.CS
.nf
VOID sysBCLSet (mask, value, latchNum)
    ULONG mask;         /* which bits to change */
    ULONG value;        /* what to change bits to */
    int latchNum;       /* Board control latch to set */
.fi
.CE
.SH DESCRIPTION
This routine sets bits in the board control latch on the mz7122/24 board.
This routine sets and clears bits in a local copy of the latch, then
writes that local copy to the latch.  This means that all changes to
the latch must go through this routine.  Otherwise, any direct changes
to the latch would be lost the next time this routine is called.

The parameter "mask" determines which bits will be set, and "value"
determines the value to which those bits will be set.
In  other words, newBCL = (oldBCL & ~mask) | (value & mask).

This routine must be called in supervisor mode.

.SH SEE ALSO
sysLib(1),
sysBCLGet (2)
