.TH Target 5 "MVME-147" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
MVME-147
.SH BOOTING
.PP
The MVME-147 uses the standard VxWorks two ROM set.
The even ROM goes in socket U1 and the odd ROM goes in U2.
With 27512's pin 1 should begin 2 pinholes down from the top of the socket.
The file bootrom.hex contains the S-record of the bootrom.
Follow the instructions in the ``Getting Started'' chapter to load VxWorks.
.PP
Note that this board has non-volatile RAM.  In order to program it
with the VxWorks boot information, use the ``c'' command on the boot
ROMs.  Once the non-volatile RAM is set up, the CPU can be auto-booted
by simply typing ``@'' to the boot ROMs.
.SH "JUMPERING"
.PP
The following jumpers must be changed from the factory defaults.
Consult the MVME-147 manual for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.

.CS
.nf
J3,J4 - ROM configuration - configure for 64K * 8 devices.
J5    - system controller - install if board is to be system
                            controller (factory default).
                            NOTE that there must be only one
                            system controller on the back plane
                            and it must be in the first slot.
.fi
.CE

.SH "DEVICES"
.PP
VxWorks supplies a driver for the on-board serial ports.
The console device is created in usrConfig.c, named "/tyCo/0".
A second device is created called "/tyCo/1".
Additional devices may be created for the remaining 2 channels.
.PP
A network interface for the onboard LANCE chip allows VxWorks
to run without an additional network board.
The interface is called "ln" and should be specified as
the boot device to the boot ROMs.
.PP
A device driver for the onboard SCSI controller has not been developed.

.SH "SPECIAL CONSIDERATIONS"
.PP
The CPU's base VMEbus address is set in software.
It is set to 0x800000 in sysHwInit (2) and must be
a multiple of local RAM size.
If changed LOCAL_MEM_BUS_ADRS in config.h should be changed appropriately.
.PP
The MVME-147 will access 24 bit standard VME space in the range
0x400000 - 0xefffff.
It will access 32 bit extended VME space in the range 0xf00000 - 0xff7fffff.
VMEbus short I/O space (16 bit address) is available in the range
0xffff0000 - 0xffffffff.
.PP
To get back to VxWorks boot ROMs one issues a control-X,
which resets all network drivers and then goes back to the rom monitor.
Memory is not cleared during a reboot, so application debugging
is still possible.
The front panel Abort Switch will also cause a reboot sequence.
.PP
All serial devices, SCSI and LANCE connectors appear on the P2 connector.
The MVME712/MVME712M Transition Module provides convenient access.
.SH AUTHOR
Original port of the MVME-147 by
Dennis McGhie of De la Rue Giori, Sunnyvale, CA
