.TH sysProcNumSet 2 "Motorola MVME 147" "VxWorks Reference Manual"
.ad b
.SH NAME
sysProcNumSet - set processor number
.SH SYNOPSIS
.CS
.nf
VOID sysProcNumSet (procNum)
    int procNum;                /* processor number */
.fi
.CE
.SH DESCRIPTION
Set the processor number for this CPU.  Processor numbers should be
unique on a single backplane.

.SH NOTE
The MVME-147 supports four different mappings of local memory to
VME address space.  There are separate specifications for EXT
and STD address spaces, so in theory up to 8 CPUs could be
mapped simultaneously.  A more practical limit is 3.  Since
the mapping is somewhat complicated, and vxWorks only requires
mapping for processor 0, and then only for backplane networks,
the implementation of multiple CPU mapping is left as an
exercise for the reader.  On the other hand the VMEchip GCSR
address can be specified anywhere from 0x00 to 0xe0 in increments
of 0x10 in the short I/O space.  This can allow up to 15 CPUs
in the same cage to form a backplane network using signal
interrupts to coordinate their activities.
.SH SEE ALSO
sysLib(1)
