.TH Target 5 "MVME-135" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: MVME-135
.SH BOOTING
.PP
The MVME-135 uses the standard two EPROM VxWorks set.
The even ROM goes in socket U56 and the odd ROM goes in U54.
The file bootrom.hex contains the S-record of the bootrom.
Follow the instructions in the ``Getting Started'' chapter to load VxWorks.
.PP
The factory default of the jumpers for setting the EPROM size for 27512's
is correct.
.SH JUMPERING
.PP
There are no jumpers on the MVME-135 that need to be changed to run VxWorks --
the factory configuration is fine.  Many attributes of the board that are 
ususally set by jumpers are instead configurable in software by
Vxworks.   A few are also configured by the switches on the front
panel of the MVME-135. 

.PP
.SH "SWITCHES"
.PP
.IP SW3*
A few MVME-135 configuration parameters are determined by the front panel
switches.  One such is the "id-byte".  The id-byte determines
the VMEbus address of MVME-135 RAM.  Also determined by the id-byte is
the VME bus address of the MP-CSR, the MVME-135's multi-processor
control/status register (See the MVME-135 manual for details of the
MP-CSR.). 
.PP
The MVME-135 id-byte is determined by the SW3 switch block on the front
panel, as follows (1 here means the switch is switched over to the right,
which corresponds to "off" in the Motorola documentaion;
x stands for either 1 or 0):
.PP
.nf
       SW3 Setting
     1 2 3 4 5 6 7 8				RAM base address
     ---------------				----------------
     x x x 0 0 0 0 0				0x0000 0000
     x x x 0 0 0 0 1				0x0010 0000
     x x x 0 0 0 1 0				0x0020 0000
     x x x 1 1 1 0 0				0x01c0 0000
     x x x 1 1 1 0 1				0x01d0 0000
     x x x 1 1 1 1 0				0x01e0 0000
.fi
.PP				
Note:  other settings are illegal and may cause problems.
VxWorks will automatically determine the VME address of the MVME-135's
RAM from these switches, and therefore it is not necessary to recompile
any modules when you change this setting.
.PP
.IP SW4*
Within the SW4 block of front panel switches:
.nf
	* Switch 1 controls if the MVME-135 is system controller.
	  In the on position (to the left makes it system controller).
	* Switch 2 if on (to the left) enables the abort and reset buttons.
	* The other switches in the SW4 block are not used with VxWorks.
.fi
.SH "DEVICES"
.PP
VxWorks supplies a driver for the on-board serial port.  A device is created
in usrConfig.c.  It is named "/tyCo/0".  There is no driver provided for the
serial channels on the backplane.
.SH "NETWORK BOARD JUMPERING"
.PP
This CPU currently works with all VxWorks network drivers.  
.CS
  BOARD           IO-ADRS
 -------         ---------
 Excelan 202      0xff0000
 CMC ENP          0xde0000
 ISI nw           0xf80000
.CE
.PP
The CPU requires no jumpering to handle VME bus interrupts for network
boards -- interrupts are enabled in software.  Individual network boards
will need to have their VME bus addresses and interrupt level's
jumpered properly to work with VxWorks.  See the network board
jumpering section in the generic portion of the VxWorks Manual for
each network board's interrupt level and configuration details, or use
the program jump (4) to configure the network boards.
.SH "SPECIAL CONSIDERATIONS"
.PP
This CPU will access 24 bit standard VME space in the range 0x100000 -
0xefffff.
This CPU will access 32 bit extended VME space in the range 0xf00000 -
0xffdfffff.
VMEbus short io space (16 bit address) is available in the range 0xffff0000 -
0xffffffff.
.PP
To get back to VxWorks bootroms one types control-x, which resets all network
drivers and then goes back to the rom monitor.  Memory is not cleared
during a reboot, so application debugging is still possible.
.PP
The MVME-135 uses the A and C rows of the P2 bus; this may conflict with
other CPU's.  A number of vendors use these buses as high speed memory
buses to their own memory boards.  See the MVME-135 manual for details.

.SH "INTERRUPT STRUCTURE"

.CS
                                                    cpu int
                                                     level
                                                    -------
 abort  ------+                                         
               >--------------------------------------  autovec 7
 ac fail -----+                                         
                                                         
 cio timer ---+
               >--------------------------------------  autovec 6
 sysfail -----+
 
 sio (duart)--+
               >--------------------------------------  autovec 5
 sighp -------+

 vsbirq ----------------------------------------------  autovec 4

 lmirq -------+
               >--------------------------------------  autovec 2
 siglp -------+

 vectored
 --------
 IRQ 1 -----------------------------------------------  1
 IRQ 2 -----------------------------------------------  2
 IRQ 3 -----------------------------------------------  3
 IRQ 4 -----------------------------------------------  4
 IRQ 5 -----------------------------------------------  5
 IRQ 6 -----------------------------------------------  6

.CE
