.TH Target 5 "MVME-133" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
MVME-133, MVME-133A, MVME-133XT, MVME-134
.SH BOOTING
.PP
The MVME-133 series uses the standard VxWorks two EPROM set.
On the MVME-133 / MVME-133A, the even ROM goes in socket XU31 and
the odd ROM goes in XU46.
On the MVME-133XT / MVME-134, the even ROM goes in socket XU31 and
the odd ROM goes in XU12.
The file bootrom.hex contains the S-record of the bootrom.
The VxWorks bootrom code is the same for all four boards.
Follow the instructions in the ``Getting Started'' chapter to load VxWorks.
.PP
The factory default of 64K * 8 EPROM size is correct.
.SH "JUMPERING"
.IP "MVME-133 / MVME-133A"
The following jumpers must be changed from the factory defaults.
Consult the MVME-133 / MVME-133A manual for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.

.CS
.nf
JB1  - system controller - install if board is to be system
                           controller (factory default).
                           NOTE that there must be only one
                           system controller on the back plane
                           and it must be in the first slot.
JB2  - base io address   - the factory default of 0x00000000 is
                           correct.
JB12 - interrupt enables - this jumper block determines to which
                           VMEbus interrupts the CPU will respond. 
                           The two pins should be jumpered together
                           for any interrupt levels the CPU should
                           respond.  It should be set to respond
                           the interrupt required by the network
                           board.  See the network jumpering
                           section for interrupt levels.
.fi
.CE

.IP "MVME-133XT / MVME-134"
The following jumpers must be changed from the factory defaults.
Consult the MVME-133XT / MVME-134 manual for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
J1  - abort switch      - leave this jumper in the factory
                          configuration, enabling the abort switch. 
J2  - watchdog reset    - remove this jumper, disabling watchdog
                          resets.
J4  - system controller - install if board is to be system
                          controller (factory default).
                          NOTE that there must be only one
                          system controller on the back plane
                          and it must be in the first slot.
J13 - interrupt enables - this three level jumper block determines
                          to which VMEbus interrupts the CPU will
                          respond.  The top two pins should be
                          jumpered together for any interrupt
                          levels the CPU should respond.  It
                          should be set to respond to the
                          interrupt required by the network board.
                          See the network jumpering section for
                          interrupt levels.

J15 MVME-133XT, or
J16 MVME-134
   - VMEbus RAM address - determines the location of the base of
                          RAM on the VMEbus.  Factory default is
                          0x000000000.  May be jumpered for any
                          address provided the value of
                          LOCAL_MEM_BUS_ADRS in
                          vw/config/mv133/config.h is changed
                          and vxWorks is recompiled.
J16 MVME-133XT, or
J19 MVME-134
  - bus error interrupt - remove to disable bus error interrupts.
.fi
.CE

.SH "DEVICES"
.PP
VxWorks supplies a driver for the on-board serial port.  A device is created
in usrConfig.c.  It is named "/tyCo/0".  There is no driver provided for the
serial channels on the backplane.
.SH "NETWORK BOARD JUMPERING"
.PP
This CPU works with all VxWorks network drivers.
HOWEVER, OWING TO RESTRICTED ACCESS TO THE VMEbus,
MANY BOARDS REQUIRE DIFFERENT IO-ADRS CONFIGURATION.
.CS
.nf
  BOARD           IO-ADRS
 -------         ---------
 Excelan 202      0x7f0000
 CMC ENP-10       0xde0000
 ISI nw           0x780000
.fi
.CE

The CPU must be jumpered to acknowledge the network board's interrupt level by
configuring jumper block JB12.  See the network board jumpering section for
each board's interrupt level and configuration details.
.SH "SPECIAL CONSIDERATIONS"
.PP
If the CPU's base VMEbus address must be changed then the parameter
LOW_BYTE_BUS_ADRS in config.h should be changed appropriately.
.IP "MVME-133 / MVME-133A:"
This CPU can only access 24 bit standard VME space in the ranges
0x100000 - 0xf00000, 0xfc0000 - 0xff0000.
VMEbus short io space (16 bit address) is available in the range
0xff0000 - 0x1000000.
There is no support for extended addressing.
.IP "MVME-133XT / MVME-134:"
This CPU will access 24 bit standard VME space in the range
0x400000 - 0xefffff.
This CPU will access 32 bit extended VME space in the range
0xf00000 - 0xffefffff.
VMEbus short io space (16 bit address) is available in the range
0xffff0000 - 0xffffffff.
.PP
To get back to VxWorks bootroms one issues a control-X, which resets all network
drivers and then goes back to the rom monitor.  Memory is not cleared
during a reboot, so application debugging is still possible.
.PP
These boards use several lines on the P2(a,c) bus that may conflict with
other CPU's.  Some vendors use these busses as high speed memory
busses to their own memory boards.  It is desirable to work in a chassis
that does not bus P2(a,c), so it can be bussed at the discretion of the user.
.bp
.SH "INTERRUPT STRUCTURE: MVME-133 / MVME-133A"

.CS
.nf
                                                    cpu int
                                                     level
                                                    -------
 abort  ------+                                         
               >--------------------------------------  autovec 7
 ac fail -----+                                         
                                                         
 RTC   -----------------------------------------------  autovec 4
 
 vectored
 --------
 IRQ 1 -----------------------------------------------  1
 IRQ 2 -----------------------------------------------  2
 IRQ 3 -----------------------------------------------  3
 IRQ 4 -----------------------------------------------  4
 IRQ 5 -----------------------------------------------  5
 IRQ 6 -----------------------------------------------  6
 IRQ 7 -----------------------------------------------  7
                                                        
                                     ---------          
                                     |  MFP  |          
                    DRTS/DDTR -------|0      |          
                  VMEbus BERR -------|1      |          
                          LTO -------|2      |          
                                -----|3      |--------  5
                                -----|4      |          
                                -----|5      |          
                         OIRQ -------|6      |          
                      SYSFAIL -------|7      |          
                                     ---------          
 mirq  -----------------------------------------------  2
 Z8530 SIO -------------------------------------------  6
.fi
.CE
.bp
.SH "INTERRUPT STRUCTURE: MVME-133XT / MVME-134"

.CS
.nf
                                                    cpu int
                                                     level
                                                    -------
 abort  ------+                                         
               >--------------------------------------  autovec 7
 ac fail -----+                                         
                                                         
 vectored
 --------
 IRQ 1 -----------------------------------------------  1
 IRQ 2 -----------------------------------------------  2
 IRQ 3 -----------------------------------------------  3
 IRQ 4 -----------------------------------------------  4
 IRQ 5 -----------------------------------------------  5
 IRQ 6 -----------------------------------------------  6
 IRQ 7 -----------------------------------------------  7
 Bus Error (if jumpered) -----------------------------  7
                                                        
                                     ---------          
                                     |  MFP  |          
                         DRTS -------|0      |          
                  VMEbus BERR -------|1      |          
                          LTO -------|2      |          
                                -----|3      |--------  6
                                -----|4      |          
                                -----|5      |          
                         OIRQ -------|6      |          
                      SYSFAIL -------|7      |          
                                     ---------          
 Z8530 SCC -------------------------------------------  5
.fi
.CE
