.TH sysLib 1 "Motorola MVME 133" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLib.c - MVME-133/133A/133XT/134 system dependent library 
.SH SYNOPSIS
.nf
sysModel - return model name of the system CPU
sysHwInit - initialize hardware
sysMemTop - get top of memory address
sysToMonitor - transfer to rom monitor
sysClkConnect - connect routine to system clock interrupt
sysClkDisable - turn off system clock interrupts
sysClkEnable - turn system clock interrupts on
sysClkRateGet - get rate of system clock
sysClkRateSet - set rate of system clock
sysAuxClkConnect - connect a routine to the auxiliary clock interrupt
sysAuxClkDisconnect - disconnect a routine from the auxiliary clock interrupt
sysAuxClkDisable - turn off auxiliary clock interrupts
sysAuxClkEnable - turn auxiliary clock interrupts on
sysAuxClkRateGet - get rate of auxiliary clock
sysAuxClkRateSet - set rate of auxiliary clock
sysLocalToBusAdrs - convert local address to bus address
sysBusToLocalAdrs - convert bus address to local address
sysIntDisable - disable interrupt level
sysIntEnable - enable interrupt level
sysBusIntAck - acknowledge interrupt
sysBusIntGen - generate interrupt
sysMailboxConnect - connect routine to the mailbox interrupt
sysMailboxEnable - enable mailbox interrupt
sysProcNumGet - get processor number
sysProcNumSet - set processor number
sysBusTas - test and set across VME bus
sysNvRamGet - get contents out of non-volatile RAM
sysNvRamSet - write to non-volatile RAM

char *sysModel ()
VOID sysHwInit ()
char *sysMemTop ()
STATUS sysToMonitor (startType)
STATUS sysClkConnect (routine, arg)
VOID sysClkDisable ()
VOID sysClkEnable ()
int sysClkRateGet ()
VOID sysClkRateSet (ticksPerSecond)
STATUS sysAuxClkConnect (routine, arg)
VOID sysAuxClkDisconnect ()
VOID sysAuxClkDisable ()
VOID sysAuxClkEnable ()
int sysAuxClkRateGet ()
VOID sysAuxClkRateSet (ticksPerSecond)
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
STATUS sysBusToLocalAdrs (adrsSpace, busAdrs, pLocalAdrs)
STATUS sysIntDisable (intLevel)
STATUS sysIntEnable (intLevel)
int sysBusIntAck (intLevel)
STATUS sysBusIntGen (level, vector)
STATUS sysMailboxConnect (routine, arg)
STATUS sysMailboxEnable (mailboxAdrs)
int sysProcNumGet ()
VOID sysProcNumSet (procNum)
BOOL sysBusTas (addr)
STATUS sysNvRamGet (string, strLen, offset)
VOID sysNvRamSet (string, strLen, offset)
.fi
.SH DESCRIPTION
This library contains a set of routines to manipulate the primary functions
of the CPU board.  The goal is to provide a board-independant interface on
which VxWorks and application code can be built in a system-independant way.
Not every feature of every board is supported by this library; a particular
board may have various extensions to the capabilities described here.
Also not every board will support all the functions provided by this library.
And some boards provide some of the functions of this library with hardware
switches, jumpers, or PALs, instead of software controllable registers.

The funtions addressed here include:

    initialization functions:
        - initialize hardware to known state
        - identify the system

    memory/address space functions:
        - get on-board memory limit
        - map from local to bus and bus to local address spaces
        - enable/disable cache memory
        - set/get non-volatile RAM

    bus interrupt functions:
        - enable/disable bus interrupt levels
        - generate bus interrupts

    serial channel functions (see tyCoDrv):
        - enable/disable serial channel interrupts
        - set serial channel baud rates
        - get/put bytes from a serial channel

    clock/timer functions:
       - enable/disable timer interrupts
       - set timer periodic rate

    mailbox/location monitor functions:
       - enable mailbox/location monitor interrupts

.SH MVME133 VARIATIONS
This library supports several variations of the MVME133 board,
the MVME133, MVME133A, MVME133XT and the MVME134.
When hardware is initialized in sysHwInit(2), the appropriate
memory map addresses are determined.

The MVME133 and MVME133A use the MM58274 real time clock,
have 1 Meg. of RAM and are the same except that the
MVME133 has only a 24 bit address space.

The MVME133XT and MVME134 use the MT48TO2 real time clock,
have 4 Meg. of RAM and are the same except that the
MVME133XT has a Floating Pointing Coprocessor MC68882, while the
MVME134 has a Paged Memory Management Unit MC68851.
