.TH sysLib 1 "Matrix MS-CPU100 / MS-CPU110" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLib.c - Matrix MS-CPU100 system dependent library 
.SH SYNOPSIS
.nf
sysModel - return model name of the system CPU
sysHwInit - initialize hardware
sysMemTop - get top of memory address
sysToMonitor - transfer to rom monitor
sysClkConnect - connect routine to system clock interrupt
sysClkDisable - turn off system clock interrupts
sysClkEnable - turn system clock interrupts on
sysClkRateGet - get rate of system clock
sysClkRateSet - set rate of system clock
sysAuxClkConnect - connect a routine to the auxiliary clock interrupt
sysAuxClkDisconnect - clear the auxiliary clock routine
sysAuxClkDisable - turn off auxiliary clock interrupts
sysAuxClkEnable - turn auxiliary clock interrupts on
sysAuxClkRateSet - set rate of auxiliary clock
sysAuxClkRateGet - get the auxiliary timer frequency
sysTodcConnect - connect routine to time-of-day clock interrupt
sysLocalToBusAdrs - convert local address to bus address
sysBusToLocalAdrs - convert bus address to local address
sysIntEnable - enable VME interrupt level
sysIntDisable - disable VME interrupt level
sysBusIntAck - acknowledge VME interrupt
sysBusIntGen - generate VME interrupt
sysMailboxConnect - connect routine to the mailbox interrupt
sysMailboxEnable - enable mailbox interrupt
sysMailboxDisable - disable mailbox interrupt
sysProcNumGet - get processor number
sysProcNumSet - set processor number
sysBusTas - test and set across VME bus
sysSysFailEnable - enable recept of system fail interrupt
sysNvRamGet - get contents out of non-volatile RAM
sysNvRamSet - write to non-volatile RAM

char *sysModel ()
VOID sysHwInit ()
char *sysMemTop ()
STATUS sysToMonitor (startType)
VOID sysClkConnect (routine, arg)
VOID sysClkDisable ()
VOID sysClkEnable ()
int sysClkRateGet ()
VOID sysClkRateSet (ticksPerSecond)
STATUS sysAuxClkConnect (routine, parm)
VOID sysAuxClkDisconnect ()
VOID sysAuxClkDisable ()
VOID sysAuxClkEnable ()
VOID sysAuxClkRateSet (ticksPerSecond)
int sysAuxClkRateGet ()
VOID sysTodcConnect (routine, arg)
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
STATUS sysBusToLocalAdrs (adrsSpace, busAdrs, pLocalAdrs)
STATUS sysIntEnable (intLevel)
STATUS sysIntDisable (intLevel)
STATUS sysBusIntAck (intLevel)
STATUS sysBusIntGen (intLevel)
STATUS sysMailboxConnect (routine, arg)
STATUS sysMailboxEnable (mailboxAdrs)
STATUS sysMailboxDisable ()
int sysProcNumGet ()
VOID sysProcNumSet (procNum)
BOOL sysBusTas (addr)
STATUS sysSysFailEnable ()
STATUS sysNvRamGet (string, strLen, offset)
VOID sysNvRamSet (string, strLen, offset)
.fi
.SH DESCRIPTION
This library contains a set of routines to manipulate the primary functions
of the CPU board.  The goal is to provide a board-independant interface on
which VxWorks and application code can be built in a system-independant way.
Not every feature of every board is supported by this library; a particular
board may have various extensions to the capabilities described here.
Also not every board will support all the functions provided by this library.
And some boards provide some of the functions of this library with hardware
switches, jumpers, or PALs, instead of software controllable registers.

The funtions addressed here include:

    initialization functions:
        - initialize hardware to known state
        - identify the system

    memory/address space functions:
        - get on-board memory limit
        - map from local to bus and bus to local address spaces
        - enable/disable cache memory
        - set/get non-volatile RAM

    bus interrupt functions:
        - enable/disable bus interrupt levels
        - generate bus interrupts

    serial channel functions (see tyCoDrv):
        - enable/disable serial channel interrupts
        - set serial channel baud rates
        - get/put bytes from a serial channel

    clock/timer functions:
       - enable/disable timer interrupts
       - set timer periodic rate

    mailbox/location monitor functions:
       - enable mailbox/location monitor interrupts

