.TH Target 5 "Ironics IV-1624A" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: Ironics IV-1624A
.SH BOOTING
.PP
The IV-1624A board uses normal VxWorks boot ROMs.  Simply program the
ROMs (from the file bootrom.hex), insert them into the CPU board, and
follow the instructions in the ``Getting Started'' chapter.
See JUMPERING for correct setup.
.SH DEVICES
.PP
VxWorks supplies a driver for the eight on-board serial ports on the CPU
board.  However, a device is only created on channel 0 in usrConfig.c.
It is named "/tyCo/0".  More serial devices can be create on the
remaining 7 serial channels at any time, and by any name.
.SH JUMPERING
.PP
The Ironics default jumpering is correct except for the EPROM size setup.
(However, see the section below on "VMEbus Protocol Violation".)
This should be changed to 27512 devices by setting jumpers as follows:

  J1       J2      J3
 -----    ------   ------
  in      [1-2]   [2-3]   -------> 27512 type EPROMS
  
VxWorks uses "mailbox" interrupts whenever possible to effect the
backplane communications.  On the Ironics IV-1624A, this means using the
location monitor that operates in the top 256 bytes of static ram.
Each board in the system must have a unique mailbox address, so in
the case of the IV-1624A, each board must have its static ram at a
unique address.  Currently the config.h supplied with VxWorks
assumes the following addresses for each CPU number
and the corresponding jumpering:

            DRAM     Static Ram
 CPU     Address     Address      J25     J8
  ---      ----------    ----------       ----     ----
   0       d00000      f80000       In      In
   1       a00000      f90000       In      Out
   2       e00000      fa0000       Out     In
   3       b00000      fb0000       Out     Out

There are 10 Mhz and 12 Mhz versions of the IV-1624A.
The first of the 4 software jumpers (J10-J13) is used for differentiation.
Jumper J10 (bit 0) should be to the left (away from board edge)
for 12 Mhz version, and to the right (towards edge) for the 10 Mhz version.

.SH "NETWORK BOARD JUMPERING"
.PP
See the network board jumpering section for each board's interrupt level and
standard VxWorks configuration.  This CPU currently works with all network
drivers and takes the standard network board configurations with the following
exceptions.  The Excelan EXOS-202 requires an I/O address of 0x7f0000.
.PP
If using an Excelan EXOS-202, the constant LOCAL_MEM_BUS_ADRS must accurately
reflect jumpering of J25 and J8 (currently setup correctly for CPU 0).
Also note that the CMC Ethernet board I/0 address conflicts with CPU 0.
Either choose a new CPU number or change config.h and the CMC jumpers so
that the CMC I/O address is compatible.

.SH "INTERRUPT STRUCTURE"
.PP
Masking of interrupts is achieved via the software controlled IVHAN chip.  
Interrupt levels used by the network boards are defined in iv24/config.h.

.SH "SPECIAL CONSIDERATIONS"
.PP
The IV-1624A has an incompatible bus map with the Motorola MVME-133.
If this configuration is needed, special PALs are available from Ironics.

.SH "VMEbus PROTOCOL VIOLATION CAUSING BUS COLLISIONS"
.PP
The IV-1624A has a hardware bug that, under certain circumstances,
can cause a serious VMEbus protocol violation.
The violation can cause a bus-collision where both the IV-1624A and some
other VMEbus master both think they own the bus.  This will generally
cause bus timeouts on both the boards and then potentially lock up the bus.
Apparently, the problem stems from a race in the bus interface chip
(Signetics 68175) when Bus-Release is asserted just before the chip is
about to initiate a bus access.
.PP
The simplest solution is to jumper the IV-1624A to release the bus after
every indivisable bus-cycle, rather than the default jumpering for
release-on-request.  To do this, remove the jumper J16.
This will eliminate the circumstances under which
the violation occurs, with some additional overhead for bus accesses.
Alternative solutions may be available from Ironics.
