.TH sysBusIntGen 2 "Ironics IV-1624A" "VxWorks Reference Manual"
.ad b
.SH NAME
sysBusIntGen - generate interrupt
.SH SYNOPSIS
.CS
.nf
STATUS sysBusIntGen (level, vector)
    int level;  /* VME bus interrupt level to generate (1-7) */
    int vector; /* interrupt vector to generate (0-255)      */
.fi
.CE
.SH DESCRIPTION
This routine generates a VME bus interrupt of the specified level with
the specified vector.

.SH NOTE IV-1624A
The interrupt generator uses the interrupt level as the
least significant 3 bits of the vector it will generate during the IACK cycle.
Thus this routine will report an error if the least significant 3 bits of the
specified vector is not equal to the specified interrupt level.

.SH RETURNS
 OK, or
 ERROR if least significant 3 bits of the specified vector is not
 equal to the specified level
.SH SEE ALSO
sysLib(1)
