.TH sysLib 1 "Integrated Solutions VME-68k20" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLib.c - Integrated Solutions 68K20 system dependent library 
.SH SYNOPSIS
.nf
sysModel - return model name of the system CPU
sysHwInit - initialize hardware
sysMemTop - get top of memory address
sysToMonitor - transfer to rom monitor
sysClkConnect - connect routine to system clock interrupt
sysClkDisable - turn off system clock interrupts
sysClkEnable - turn system clock interrupts on
sysClkRateGet - get rate of system clock
sysClkRateSet - set rate of system clock
sysAuxClkConnect - connect a routine to the auxiliary clock interrupt
sysAuxClkDisconnect - clear the auxiliary clock routine.
sysAuxClkDisable - turn off auxiliary clock interrupts
sysAuxClkEnable - turn auxiliary clock interrupts on
sysAuxClkRateGet - get the auxiliary timer frequency
sysAuxClkRateSet - set the auxiliary timer frequency
sysLocalToBusAdrs - convert local address to bus address
sysBusToLocalAdrs - convert bus address to local address
sysIntDisable - disable interrupt level
sysIntEnable - enable interrupt level
sysBusIntAck - acknowledge interrupt
sysBusIntGen - generate interrupt
sysMailboxConnect - connect routine to the mailbox interrupt
sysMailboxEnable - enable mailbox interrupt
sysProcNumGet - get processor number
sysProcNumSet - set processor number
sysBusTas - test and set across VME bus
sysImrSet - set and clear bits in the USART's interrupt mask register
sysUsartConnect - set interrupt routines for the USART

char *sysModel ()
VOID sysHwInit ()
char *sysMemTop ()
STATUS sysToMonitor (startType)
STATUS sysClkConnect (routine, arg)
VOID sysClkDisable ()
VOID sysClkEnable ()
int sysClkRateGet ()
VOID sysClkRateSet (ticksPerSecond)
STATUS sysAuxClkConnect (routine, arg)
VOID sysAuxClkDisconnect ()
VOID sysAuxClkDisable ()
VOID sysAuxClkEnable ()
int sysAuxClkRateGet ()
VOID sysAuxClkRateSet (ticksPerSecond)
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
STATUS sysBusToLocalAdrs (adrsSpace, busAdrs, pLocalAdrs)
STATUS sysIntDisable (intLevel)
STATUS sysIntEnable (intLevel)
int sysBusIntAck (intLevel)
STATUS sysBusIntGen (level, vector)
STATUS sysMailboxConnect (routine, arg)
STATUS sysMailboxEnable (mailboxAdrs)
int sysProcNumGet ()
VOID sysProcNumSet (procNum)
BOOL sysBusTas (addr)
VOID sysImrSet (setBits, clearBits)
VOID sysUsartConnect (recvRoutine, xmitRoutine)
.fi
.SH DESCRIPTION
This library contains a set of routines to manipulate the primary functions
of the CPU board.  The goal is to provide a board-independant interface on
which VxWorks and application code can be built in a system-independant way.
Not every feature of every board is supported by this library; a particular
board may have various extensions to the capabilities described here.
Also not every board will support all the functions provided by this library.
And some boards provide some of the functions of this library with hardware
switches, jumpers, or PALs, instead of software controllable registers.

The funtions addressed here include:

    initialization functions:
        - initialize hardware to known state
        - identify the system

    memory/address space functions:
        - get on-board memory limit
        - map from local to bus and bus to local address spaces
        - enable/disable cache memory
        - set/get non-volatile RAM

    bus interrupt functions:
        - enable/disable bus interrupt levels
        - generate bus interrupts

    serial channel functions (see tyCoDrv):
        - enable/disable serial channel interrupts
        - set serial channel baud rates
        - get/put bytes from a serial channel

    clock/timer functions:
       - enable/disable timer interrupts
       - set timer periodic rate

    mailbox/location monitor functions:
       - enable mailbox/location monitor interrupts

.SH BUGS
The routine sysToMonitor (2) doesn't work because the trap vector
is squirreled away after usrInit (2) sets up VxWorks exception vectors.
The auxiliary clock doesn't work.
