.TH Target 5 "Heurikon HK68/V2F" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information: Heurikon HK68/V2F
.SH BOOTING
.PP
The HK68/V2F board uses the normal VxWorks boot ROMs.  Simply program the
ROMs (from the file bootrom.hex), insert them into the CPU board, and
follow the instructions in the ``Getting Started'' chapter.
.PP
Note that this board has non-volatile RAM.  In order to program it
with the VxWorks boot information, use the ``c'' command on the boot
ROMs.  Once the non-volatile RAM is set up, the CPU can be auto-booted
by simply typing ``@'' to the boot ROMs.
.SH JUMPERING
.PP
The only jumpering change required on the CPU is to set it up for
27512 ROMs in both ROM sockets.
.SH DEVICES
.PP
VxWorks supplies a driver for the on-board serial port on the CPU
board.  A device on the serial port is created in usrConfig.c.
It is named "/tyCo/0".
.SH NETWORK BOARD JUMPERING
.PP
This CPU can boot from all of the network devices.
See the network documentation to configure the network boards.
.SH SPECIAL CONSIDERATIONS
.PP
The Heurikon HK68/V2F board must have power on the P2 bus.
.PP
In multi-processor applications a separate system controller card is advised.
When the HK68/V2F is not the system controller it times out bus accesses.
To prevent this, the timeout selected on the system controller should
be faster than the HK68/V2F (< 1.6 ms).
.bp
.SH HEURIKON INTERRUPT STRUCTURE
.PP
The Heurikon HK68/V2F board handles interrupts in two different ways.
Some interrupts are wired directly to the CPU.  Others go through
the MFP chip (multi-function peripheral).
The way the interrupts are enabled, vectored, and acknowledged,
and the CPU interrupt level used,
are different for the two types of interrupts.
.PP
The following is a map of the interrupt connections to the CPU:

.CS
                                                    CPU INT
                                                     level
                                                    -------
 parity error-+
               >--------------------------------------  7
 ac fail -+---+
          |
 IRQ 6 ------+----------------------------------------  6
          |  |
 IRQ 5 -----------------------------------------------  5
          |  |                       ---------
          |  |                       |  MFP  |
          |  |          IRQ 7 -------|7      |
          |  +---------(IRQ 6)-------|6      |
          |             mbox  -------|5      |
          |             IRQ 4 -------|4      |--------  4
          |             int pend ----|3      |
          |             IRQ 2 -------|2      |
          +------------(ac fail)-----|1      |
                        sys fail ----|0      |
                                     ---------
 IRQ 3 -----------------------------------------------  3
 mirq  -----------------------------------------------  2
 IRQ 1 -----------------------------------------------  1
.CE
 
.SH VME INTS CONNECTED DIRECTLY TO THE CPU
.PP
VMEbus interrupts 1, 3, 5, and 6 are connected directly to the CPU.
They are enabled by setting bits in the bus control latch.
In VxWorks this is done by calling the routine sysIntEnable in sysLib.c:

    sysIntEnable (intLevel)

These interrupts interrupt the CPU at their respective actual interrupt levels.
They are vectored by the vector number put on the bus by the interrupting
device.
They are automatically acknowledged by the hardware.
.SH VME INTERRUPTS CONNECTED TO THE MFP
.PP
VME interrupts 2, 4, 6, and 7 are connected to the MFP.
They are enabled by setting bits in the MFP registers.
Except for IRQ 6, this is done by calling the routine sysIntEnable in sysLib.c:

    sysIntEnable (intLevel)

(Note that IRQ 6 is special as described in a section below.)

All MFP interrupts interrupt the CPU at level 4.
They are automatically vectored to the following fixed vector numbers:

.CS

                      vector   vector
  interrupt           number   address
  ---------           ------   -------
    IRQ 2               66      0x108
    IRQ 4               70      0x118
    IRQ 6               78      0x138
    IRQ 7               79      0x13c

.CE
These interrupts must be explicitly acknowledged in software by reading
particular memory locations.
In VxWorks this is done by calling the sysBusIntAck routine in sysLib.c:

    vecNum = sysBusIntAck (intLevel)

The value returned by sysBusIntAck is the vector number that was provided on
the bus by the interrupting device.  This can be used to do further
vectoring in software, if the VMEbus interrupt level is used by more
than one device.
.SH VME IRQ 6
.PP
Note that VMEbus interrupt level 6 is connected both directly to the CPU
and to the MFP.  It can be handled either way by enabling it either
in the bus control latch (for the direct connection) or in the MFP (for the
MFP connection).  It should NOT be enabled both ways at the same time.
The VxWorks sysIntEnable routine in sysLib.c always enables the direct
connection for IRQ 6.
