.TH sysLib 1 "Heurikon HK68-V2F" "VxWorks Reference Manual"
.ad b
.SH NAME
sysLib.c - Heurikon HK68/V20,V2F,V2FA system dependent library 
.SH SYNOPSIS
.nf
sysModel - return model name of this processor board
sysHwInit - initialize the hardware on this board
sysMemTop - get the address of the top of memory
sysToMonitor - transfer execution to the ROM monitor
sysClkConnect - connect a routine to the system clock interrupt
sysClkDisable - turn off system clock interrupts
sysClkEnable - turn system clock interrupts on
sysClkRateGet - get the interrupt rate of the system clock
sysClkRateSet - set the interrupt rate of the system clock
sysAuxClkConnect - connect a routine to the auxiliary clock interrupt
sysAuxClkDisconnect - disconnect a routine from the auxiliary clock interrupt
sysAuxClkDisable - turn off auxiliary clock interrupts
sysAuxClkEnable - turn on auxiliary clock interrupts
sysAuxClkRateGet - get the interrupt rate of the auxiliary clock
sysAuxClkRateSet - set the interrupt rate of the auxiliary clock
sysLocalToBusAdrs - convert a local address to a bus address
sysBusToLocalAdrs - convert a bus address to a local address
sysIntDisable - disable a VMEbus interrupt level
sysIntEnable - enable a bus interrupt level
sysBusIntAck - acknowledge a bus interrupt
sysBusIntGen - generate a bus interrupt
sysMailboxConnect - connect a routine to the mailbox interrupt
sysMailboxEnable - enable the mailbox interrupt
sysProcNumGet - get the processor number
sysProcNumSet - set the processor number
sysBusTas - test and set a location across the VMEbus
sysBCLSet - set the bus control latch
sysBCLGet - return the current value of the bus control latch
sysMemParityError - handle a memory parity error interrupt routine
sysNvRamGet - get the contents of non-volatile RAM
sysNvRamSet - write data to non-volatile RAM
sysLED - set the user LED

char *sysModel ()
VOID sysHwInit ()
char *sysMemTop ()
STATUS sysToMonitor (startType)
STATUS sysClkConnect (routine, arg)
VOID sysClkDisable ()
VOID sysClkEnable ()
int sysClkRateGet ()
VOID sysClkRateSet (ticksPerSecond)
STATUS sysAuxClkConnect (routine, arg)
VOID sysAuxClkDisconnect ()
VOID sysAuxClkDisable ()
VOID sysAuxClkEnable ()
int sysAuxClkRateGet ()
VOID sysAuxClkRateSet (ticksPerSecond)
STATUS sysLocalToBusAdrs (adrsSpace, localAdrs, pBusAdrs)
STATUS sysBusToLocalAdrs (adrsSpace, busAdrs, pLocalAdrs)
STATUS sysIntDisable (intLevel)
STATUS sysIntEnable (intLevel)
int sysBusIntAck (intLevel)
STATUS sysBusIntGen (intLevel, vector)
STATUS sysMailboxConnect (routine, arg)
STATUS sysMailboxEnable (mailboxAdrs)
int sysProcNumGet ()
VOID sysProcNumSet (procNum)
BOOL sysBusTas (addr)
ULONG sysBCLSet (mask, value)
ULONG sysBCLGet ()
VOID sysMemParityError ()
STATUS sysNvRamGet (string, strLen, offset)
VOID sysNvRamSet (string, strLen, offset)
VOID sysLED (on)
.fi
.SH DESCRIPTION
This library contains a set of routines to manipulate the primary functions
of the CPU board.  The goal is to provide a board-independent interface on
which VxWorks and application code can be built in a system-independant way.
Not every feature of every board is supported by this library; a particular
board may have various extensions to the capabilities described here.
Also not every board will support all the functions provided by this library.
And some boards provide some of the functions of this library with hardware
switches, jumpers, or PALs, instead of software controllable registers.

The functions addressed here include:

    initialization functions:
        - initialize hardware to known state
        - identify the system

    memory/address space functions:
        - get on-board memory limit
        - map from local to bus and bus to local address spaces
        - enable/disable cache memory
        - set/get non-volatile RAM

    bus interrupt functions:
        - enable/disable bus interrupt levels
        - generate bus interrupts

    serial channel functions (see tyCoDrv):
        - enable/disable serial channel interrupts
        - set serial channel baud rates
        - get/put bytes from a serial channel

    clock/timer functions:
       - enable/disable timer interrupts
       - set timer periodic rate

    mailbox/location monitor functions:
       - enable mailbox/location monitor interrupts
