.TH Target 5 "Force SYS68K/CPU-37" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
Force SYS68K/CPU-37
.SH INSTALLING VxWORKS BOOT EPROMS
.PP
CPU-37
.PP
Install the VxWorks boot EPROMs in DIP sockets in J103 (U) and J101 (L).
This requires considerable care to ensure that all the pins
are in their sockets and that none of the pins touch the chips underneath
in the lower positions.
.PP
.SH JUMPERING
.PP
The following jumpers must be changed from the factory defaults.
Consult the Force CPU-37 documentation for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
  B20  - EPROM device size.
            set for 27512 EPROMs
  B22 - system controller:
	    install if board is to be system controller.
            NOTE that there must be only one system controller on the
            backplane and it must be in the first slot.
  B21 - sysclk:
	    install if board is to provide sysclk on the backplane.
            Again, only the first board in the backplane should provide
            sysclk.
.fi
.CE
.SH CONSOLE
.PP
VxWorks supplies a driver for the on-board serial port on the CPU board.
The console device, called "/tyCo/0", is created in usrConfig.c.
.PP
On the CPU-37, attach a standard ASCII terminal to the console port
(labeled 1 on the CPU-37)
A full 8-wire RS-232 connection to the terminal should be used.
.SH NETWORK BOARD JUMPERING
.PP
As noted in Special Considerations below, the board's local memory
is not available from the VME bus.
This impacts the Excelan Ethernet controller which does DMA to read and
write network packets.
The VxWorks driver for the Excelan controller requires a few modifications
to run in a special configuration using off-board memory to buffer packets.
Contact Wind River Systems for more information.
.PP
Other Ethernet controllers supported by VxWorks are fully functional
without modification.
.PP
See the network documentation or use the program \fIjump\fP (4) to
configure the network boards.
.SH SPECIAL CONSIDERATIONS
.PP
The Force's on-board memory is not dual ported.
This means that other boards on the VME bus cannot access the board's memory.
In particular, controllers that use DMA will not be able to write directly
to the Force memory, but instead must use additional off-card memory.
The backplane driver must use shared memory if the Force board is in slot 0.
.PP
The board has no mailbox interrupt capability nor any VME interrupt
generation capability.
This means that in multi-processor configurations the backplane network
driver for the board must be confgured either to poll or to use a
user supplied interrupt mechanism.
Force does supply an special system controller, the ASCU-2, that
provides some of these services.
A VxWorks module for the ASCU-2 is a available on an "as is" basis.
.PP
The LANCE chip needs to be informed of its ethernet address before it can
attach to the LAN.  Unfortunately the CPU-37 does not store this address on
board so there is no way to determine the address at run time.  In
usrConfig.c we put the lower two bytes of the internet number in the lowest
two bytes of the ethernet number to make it unique.  The actual licensed
ethernet number has the lower two bytes of the ethernet address corresponding
to the lower four digits of the boards serial number.
.PP
The CPU-37 does not disable the cache for on board I/O.  This fatal flaw is
remedied by use of the internal 68030 MMU register TT0.  This register defines
a logical to physical region with cacheing disabled.  Unfortunately, this
register restricts regions to begin and end on a 16MB boundary.  So we disable
the cache for the region 0xfc000000 thru 0xffffffff, which allows local ram to 
still take advantage of the cacheing.
