.TH Target 5 "Force SYS68K/CPU-31" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
Force SYS68K/CPU-31
.SH INSTALLING VxWORKS BOOT EPROMS
.PP
CPU-31
.PP
Install the VxWorks boot EPROMs in DIP sockets in J16 (UU), J14 (U), J12 (L),
and J10 (LL).  This requires considerable care to ensure that all the pins
are in their sockets and that none of the pins touch the chips underneath
in the lower positions.
.PP
.SH JUMPERING
.PP
The following jumpers must be changed from the factory defaults.
Consult the Force CPU-31 documentation for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
  B8    - EPROM device size.
            set for 27512 EPROMs
  B14   - system controller:
	    install if board is to be system controller.
            NOTE that there must be only one system controller on the
            backplane and it must be in the first slot.
  B14   - sysclk:
	    install if board is to provide sysclk on the backplane.
            Again, only the first board in the backplane should provide
            sysclk.
.fi
.CE
.SH CONSOLE
.PP
VxWorks supplies a driver for the on-board serial port on the CPU board.
The console device, called "/tyCo/0", is created in usrConfig.c.
.PP
On the CPU-31, attach a standard ASCII terminal to the console port
(labeled 1 on the CPU-31)
A full 8-wire RS-232 connection to the terminal should be used.
.SH NETWORK BOARD JUMPERING
.PP
See the network documentation or use the program \fIjump\fP (4) to
configure the network boards.
.SH SPECIAL CONSIDERATIONS
.PP
The FGA-BOOT software allows one to change the startup conditions of the
bootroms.  However the routine sysHwInit will change many of these registers
as defined by config.h/frc31.h.  The only FGA-BOOT register that is required
to be changed is CTL-9.  This control register is used to slow the EPROM access
time to 250ns.  CTL-9 should be equal 0xF.
.PP
The CPU-31 has no easy way of disabling the cache for off board accesses.
Although the FGA-002 has registers to address this problem, the pins of the chip
we're left unconnected.  The backplane driver uses shared memory to communicate
so the caches must be inhibited for off board accesses.  We achieve this by
use of the internal 68030 MMU register TT0.  This register defines a logical
to physical region with cacheing disabled.  Unfortunately, this register
restricts regions to begin and end on a 16MB boundary.  So we disable the
cache for the region 0x00100000 thru 0xffffffff, which allows local ram to 
still take advantage of the cacheing.  Note that the region of 0x400000 -
0x1000000 will be vme bus addressing with cacheing enabled.  This area should
not be used for vme i/o devices, or shared memory (as in the backplane
shared memory) due to problems of cache coherency.

.SH BOOTING
.PP
The first code to execute on this board is the 'side-kick' FGA-BOOT software.
This software initializes the FGA chip (the big one) and then transfers
control to the system EPROM.  The initial PC, and SP of the system EPROM are
used by the FGA-BOOT software to transfer control as if the system EPROM were
the startup device.  The FGA-BOOT software uses the first 0x1000 locations
of battery backed up ram for its own purposes so one should consider this region
off limits.

