.TH Target 5 "Force SYS68K/CPU-30" "VxWorks Reference Manual"
.ad b
.SH NAME
Target-Specific Information:
Force SYS68K/CPU-30
.SH INSTALLING VxWORKS BOOT EPROMS
.PP
CPU-30
.PP
Install the VxWorks boot EPROMs in DIP sockets in J10 (UU), J8 (U), J6 (L),
and J4 (LL).  This requires considerable care to ensure that all the pins
are in their sockets and that none of the pins touch the chips underneath
in the lower positions.
.PP
.SH JUMPERING
.PP
The following jumpers must be changed from the factory defaults.
Consult the Force CPU-30 documentation for details of jumper configurations.
The program \fIjump\fP (4) will assist in locating and configuring the jumpers.
.CS
.nf
  B1  - EPROM device size.
            set for 27512 EPROMs
  B10 - system controller:
	    install if board is to be system controller.
            NOTE that there must be only one system controller on the
            backplane and it must be in the first slot.
  B10 - sysclk:
	    install if board is to provide sysclk on the backplane.
            Again, only the first board in the backplane should provide
            sysclk.
.fi
.CE
.SH CONSOLE
.PP
VxWorks supplies a driver for the on-board serial port on the CPU board.
The console device, called "/tyCo/0", is created in usrConfig.c.
.PP
On the CPU-30, attach a standard ASCII terminal to the console port
(labeled 1 on the CPU-30)
A full 8-wire RS-232 connection to the terminal should be used.
.SH NETWORK BOARD JUMPERING
.PP
See the network documentation or use the program \fIjump\fP (4) to
configure the network boards.
.SH SPECIAL CONSIDERATIONS
.PP
The FGA-BOOT software allows one to change the startup conditions of the
bootroms.  However the routine sysHwInit will change many of these registers
as defined by config.h/frc30.h.  The only FGA-BOOT register that is required
to change is CTL-9.  This control register is used to slow the EPROM access
time to 250ns.  CTL-9 should be equal 0xF.
.PP
The backplane driver uses shared memory as the basis of its communication, so
it is critical that the data cache be inhibited for off board accesses.  The
FGA-002 is capable of providing this functionality and is setup to do so in
sysHwInit ().  Note that RMW cycles must be indivisible to the FRC-30 dual
ported ram to be suitable for the backplane driver.  This too is setup in
sysHwInit ().
.PP
The LANCE chip needs to be informed of its ethernet address before it can
attach to the LAN.  Unfortunately the CPU-30 does not store this address on
board so there is no way to determine the address at run time.  In
usrConfig.c we put the lower two bytes of the internet number in the lowest
two bytes of the ethernet number to make it unique.  The actual licensed
ethernet number has the lower two bytes of the ethernet address corresponding
to the lower four digits of the boards serial number.
.SH BOOTING
.PP
The first code to execute on this board is the 'side-kick' FGA-BOOT software.
This software initializes the FGA chip (the big one) and then transfers
control to the system EPROM.  The initial PC, and SP of the system EPROM are
used by the FGA-BOOT software to transfer control as if the system EPROM were
the startup device.  The FGA-BOOT software uses the first 0x1000 locations
of battery backed up ram for its own purposes so one should consider this region
off limits.
