.TH vrtxTcreateHook 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
vrtxTcreateHook - task creation hook
.SH SYNOPSIS
.CS
.nf
vrtxTcreateHook ()
.fi
.CE
.SH DESCRIPTION
This routine should be specified in the VRTX configuration table,
in usrConfig (1), as the task creation extension routine.
This addition extends the VRTX SC_TCREATE system call to include 
specification of the new task's stack address instead of using a 
VRTX allocated stack, and allows specification of a TCB extension 
address.  The following additional parameters are thus expected 
in a trap to the VRTX SC_TCREATE system call:

      a1 = bottom of stack
      a2 = initial stack pointer
      a3 = TCB extension pointer

Note that the initial stack pointer is different from the bottom of
stack if the caller has pushed initial arguments on the stack for
the new task (as in the case of the "spawn" routines).

If no bottom of stack is specified, i.e. TCREATE was called with a1 = zero, 
then the new task's stack pointers are not modified.  This allows the
normal VRTX stack allocation mechanism to be used if desired.

On entry, a1 contains a pointer to the task's TCB.
VRTX constructs the stack extension that contains the extra TCB stuff
in its own workspace (this is pointed to by TCB.SP).  We must copy this
over to the real stack that was allocated by the user (or by taskSpawn).
Also, the TCB.USP must point to the initial stack location, while
the TCB.SP must point to the extra TCB stuff on the stack (see VRTX
documentation). THIS IS NOT A C CALLABLE ROUTINE.

.SH SEE ALSO
vrtxALib(1),
taskCreateHookAdd (2)
