.TH vrtxALib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
vrtxALib.s - VxWorks/VRTX kernel assembly library 
.SH SYNOPSIS
.nf
vrtxInit - initialize VRTX
vrtxGo - start VRTX multi-tasking
vrtxTsuspend - suspend task
vrtxTresume - resume task
vrtxTpriority - task priority change
vrtxTinquiry - task inquiry
vrtxLock - disable task rescheduling
vrtxUnlock - enable task rescheduling
vrtxGblock - get memory block
vrtxRblock - release memory block
vrtxPcreate - create memory partition
vrtxPextend - extend memory partition
vrtxPost - post a message
vrtxPend - pend for message
vrtxAccept - accept a message
vrtxQpost - post message to queue
vrtxQjam - jam message to beginning of queue
vrtxQpend - pend for message from queue
vrtxQaccept - accept message from queue
vrtxQcreate - create message queue
vrtxQEcreate - create FIFO message queue
vrtxQinquiry - message queue status inquiry
vrtxFcreate - create event flag group
vrtxFdelete - delete event flag group
vrtxFpost - post event to event flag group
vrtxFpend - pend on event flag group
vrtxFclear - clear events in event flag group
vrtxFinquiry - event flag group inquiry
vrtxScreate - create semaphore
vrtxSdelete - delete semaphore
vrtxSpost - post unit to semaphore
vrtxSpend - pend on semaphore
vrtxSinquiry - semaphore inquiry
vrtxGtime - get time
vrtxStime - set time
vrtxTdelay - delay task
vrtxTslice - enable round-robin scheduling
vrtxTimer - announce timer interrupt
intEnt - enter interrupt level
intExit - leave interrupt level
vrtxTcreateHook - task creation hook
vrtxTswitchHook - task switch hook

int vrtxInit ()
int vrtxGo ()
int vrtxTsuspend (id)
int vrtxTresume (id)
int vrtxTpriority (id, priority)
int vrtxTinquiry (id, tid, priority, tstatus, tcbAddr)
VOID vrtxLock ()
VOID vrtxUnlock ()
int vrtxGblock (id, address)
int vrtxRblock (id, address)
int vrtxPcreate (id, psize, bsize, paddress)
int vrtxPextend (id, esize, eaddress)
int vrtxPost (pMailBox, message)
int vrtxPend (pMailBox, timeout, pMsg)
int vrtxAccept (pMailBox, pMsg)
int vrtxQpost (qid, message)
int vrtxQjam (qid, message)
int vrtxQpend (qid, timeout, pMsg)
int vrtxQaccept (qid, pMsg)
int vrtxQcreate (qid, count)
int vrtxQEcreate (qid, count, pendOrder)
int vrtxQinquiry (qid, pMsg, pNum)
int vrtxFcreate (pGID)
int vrtxFdelete (efgid, forceDelete)
int vrtxFpost (efgid, eventFlags)
int vrtxFpend (efgid, timeout, eventFlags, maskOpt, pEfg)
int vrtxFclear (efgid, eventFlags, pEfg)
int vrtxFinquiry (efgid, pEfg)
int vrtxScreate (initVal, pendOrder, pSem)
int vrtxSdelete (semId, forceDelete)
int vrtxSpost (semId)
int vrtxSpend (semId, timeout)
int vrtxSinquiry (semId, pSemVal)
unsigned int vrtxGtime ()
VOID vrtxStime (time)
VOID vrtxTdelay (delay)
VOID vrtxTslice (interval)
VOID vrtxTimer ()
VOID intEnt ()
intExit ()
vrtxTcreateHook ()
vrtxTswitchHook ()
.fi
.SH DESCRIPTION
This library contains support for VRTX facilities.

C callable interface routines are provided for most VRTX system calls.  
Each interface routine gets the parameters passed to it in a normal 
C fashion (on the stack) and puts them in the proper registers where 
VRTX expects to find them, then traps to VRTX.

.SH RETURNING VRTX STATUS CODES
If a VRTX system call returns an error status 
(non-zero in d0 on return from VRTX),
the interface routines set the task error status to the VRTX error code
returned, then return the value ERROR to the calling routine.  That routine
can find out the error code that VRTX returned by calling errnoGet ().
If all went well with VRTX, the interface routines return OK.

.SH TASK CREATION
No direct access is provided to the VRTX task creation system calls.
Instead all VxWorks tasks should be created by the taskSpawn (2) or
taskCreate (2) calls in taskLib (1).

.SH CHARACTER I/O
VxWorks does not use or support the character I/O facility
provided by the VRTX system calls SC_GETC, SC_PUTC, SC_WAITC,
UI_RXCHR, and UI_TXRDY.  Instead, VxWorks supplies a complete
device independent I/O system and a set of device drivers.

.SH NOTE
Many routines in this module "link" and "unlk" the C frame pointer
(a6) although they don't use it in any way.  This is only for the benefit of
the stack trace facility, to allow it to properly trace tasks executing within
these routines.
