.TH psosALib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
psosALib.s - VxWorks/pSOS kernel interface and support 
.SH SYNOPSIS
.nf
psosStartup - start pSOS multi-processing
psosVersion - return version number and revision
psosSpawnP - spawn process
psosActivateP - activate a newly spawned process
psosIdentP - name to process id, current status
psosIdentPRoot - get root process id
psosDeleteP - process delete
psosSuspendP - process suspend
psosResumeP - process resume
psosPriorityP - process priority change
psosModeP - configure pSOS scheduling
psosSuperP - put process is supervisor state
psosAllocSeg - get memory segment
psosFreeSeg - free memory segment
psosAssignSeg - assign ownership to a segment
psosGrabSeg - take ownership of a segment
psosCreatePt - create memory partition
psosDeletePt - delete memory partition
psosGetBuf - get buffer from memory partition
psosRetBuf - return buffer to a memory partition
psosCreateX - create a message exchange
psosAttachX - attach to and use an active message exchange
psosDeleteX - delete an active message exchange
psosSendX - send a message to an exchange
psosJamX - jam a message at the head of an exchange's message queue
psosLiberX - broadcast N identical messages to an exchange
psosReqX - request a message from an exchange
psosSignalV - signal an event to a process
psosWaitV - wait on a signal event
psosGetV - like psosWaitV only it never waits
psosPauseP - pause the calling process for a specified duration
psosAnnounceT - announce system time tick to time manager
psosGetT - obtain systems conception of current date and time
psosSetT - set systems conception of current date and time
psosTswitchHook - task switch hook
intEnt - enter interrupt level
intExit - leave interrupt level

VOID psosStartup ()
STATUS psosVersion (pVersion)
int psosSpawnP (name, grId, priority, stkSize, argList, pid)
int psosActivateP (pid, startAdr)
STATUS psosIdentP (name, pid, status)
int psosIdentPRoot ()
int psosDeleteP (id)
int psosSuspendP (id)
int psosResumeP (id)
int psosPriorityP (id, increment, pOldPriority)
int psosModeP (newMode, mask, oldMode)
int psosSuperP (oldSR)
int psosAllocSeg (size, region, wait, timeout, address)
int psosFreeSeg (address)
int psosAssignSeg (address, newPid)
int psosGrabSeg (address, fromPid)
int psosCreatePt (paddress, bufSize, numBufs, ptId)
int psosDeletePt (ptId, bufSize)
int psosGetBuf (ptId, bufSize,bufAdr)
int psosRetBuf (ptId, bufAdr)
int psosCreateX (name, property, msgQMax, xid)
int psosAttachX (name, xid, procQ, msgQ)
int psosDeleteX (xid)
int psosSendX (xid,msg)
int psosJamX (xid,msg)
int psosLiberX (xid, msg, minCnt, nMsg, nLib)
int psosReqX (xid, msg, wait, timeout)
int psosSignalV (id, events)
int psosWaitV (event, condition, timeout, caughtV)
int psosGetV (event, condition, caughtV)
int psosPauseP (ticks)
int psosAnnounceT ()
int psosGetT (date, time, ticks)
int psosSetT (date, time, ticks)
psosTswitchHook ()
VOID intEnt ()
intExit ()
.fi
.SH DESCRIPTION
This library contains support for pSOS facilities.

C callable interface routines are provided for most pSOS system calls.  
Each interface routine gets the parameters passed to it in a normal 
C fashion (on the stack) and puts them in the proper registers where 
pSOS expects to find them, then traps to pSOS.

.SH RETURNING PSOS STATUS CODES
If a pSOS system call returns an error status (non-zero d7 on return from pSOS),
the interface routines set the process error status to the pSOS error code
returned, then return the value ERROR to the calling routine.  That routine
can find out the error code that pSOS returned by calling errnoGet (2).
If all went well with pSOS, the interface routines return OK.

.SH TASK CREATION
No direct access is provided to the pSOS process creation system calls.
Instead all VxWorks processs should be created by the taskSpawn (2) or
taskCreate (2) calls in taskLib (1).

.SH CHARACTER I/O
VxWorks does not use or support the character I/O facility
provided by the pSOS I/O system.  Instead, VxWorks supplies a complete
device independent I/O system and a set of device drivers.

.SH NOTE
Many routines in this module "link" and "unlk" the "c" frame pointer
(a6) although they don't use it in any way.  This only for the benefit of
the stack trace facility to allow it to properly trace processs executing within
these routines.
