.WP "Application Note #2" "Wind River Systems" 4.00
.TL
VxWORKS APPLICATION NOTE #2
.sp
Porting VxWorks to a New Target CPU Board
.WI
.FS
VxWorks is a trademark of Wind River Systems, Inc.
.FE

.N 1 "INTRODUCTION"
.LP
The process of VxWorks porting to a new CPU board is challenging,
primarily because the development tools of VxWorks aren't
available until it's done!
Wind River Systems has developed a methodology that,
with a little luck, can make porting relatively painless.
This document outlines this methodology.

.N 1 "FILES"
.LP
A port for a new CPU board involves creating the following files in 
a new config/<target> directory:
.DS
    Makefile
    config.h
    <target>.h  - target specific definitions
    tyCoDrv.c   - tty console driver
    sysLib.c
    sysALib.s
    romInit.s   - for bootroms (similar to sysALib.s)
    pic_cpu.c   - jumper settings for end users (optional)
.DE
Much of the code need for these files can be derived from comparable target(s)
in other config/<target> directories.
Look for targets using the same peripheral chips.

.N 1 "THE GAME PLAN"
.LP
The easiest way to develop a new board port is to use another CPU board
for which a VxWorks port already exists as a debugger for the new board.
Put both boards on a single backplane and then boot VxWorks on the
board for which a port already exists.  Code may be loaded onto
the new board and displayed and disassembled in its memory.
.LP
Start by trying to bring up the "stand-alone" version of VxWorks,
`vxWorks.st'.  The stand-alone version has a symbol table compiled in
and does not require or initiate the network facilities.
Once this version is up, VxWorks native debugging is fully functional
and can then be used to test and debug the network facilities.

.N 1 "HARDWARE CONFIGURATION"
.LP
Set the VMEbus cage up as follows:
.DS
    slot 0	supported VxWorks CPU
    slot 1	network board for the Slot 0 processor
    slot 2	target CPU (with debug ROM monitor)
    slot 3	network board for the Slot 2 processor
    slot 4	shared memory board
.DE
The trick here is to get the two network boards,
two processors and the shared memory in different bus address ranges.
The second network board may be ommitted at first;
if so, move the memory board down a slot.
One may need to reconfigure the Slot 0
processor to accommodate the second processor.
Reconfiguring the slot 0 processor is done by changing
the constants in config.h,
re-jumpering the board (if necessary), and re-making `vxWorks' and bootroms.
The ethernet boards must use separate interrupt levels,
and the processor boards must only acknowledge the
interrupt of the ethernet board allocated to it.
The suggested bus address for the shared memory is 0x00800000 (VME STD A24).

.N 1 "THE DEBUG CYCLE"
.LP
Once the hardware is configured, boot VxWorks on CPU 0 and
bring up the CPU 1's debug ROM monitor.
Both processors must be able to see the shared memory.
On CPU 0 from VxWorks enter:
.DS
    -> d 0x800000         /* shared memory location */
.DE
.LP
First, build the stand-alone version of VxWorks by invoking
"make vxWorks.st".
Then the following script may be used to download `vxWorks.st' executable
to CPU 1.
(prepare a UNIX file named `script')
.DS
  cmd = "cat ~/vw/config/<target>/vxWorks.st"	/* remote command */
  fd = rcmd ("hostName",514,"user","user", cmd, 0)	/* open remote file */
  buf = malloc (100)                    /* allocate room for a.out header */
  read (fd, buf, 32)                    /* read in the header */
  size = *(buf + 4) + *(buf + 8)        /* calculate size of text and data */
  buf1 = malloc (size)                  /* allocate room for text and data */
  fioRead (fd, buf1, size)              /* read in the text and data */
  bcopy (buf1, 0x<vmeAdrs>, size)       /* copy text and data to second proc. */
  close (fd)                            /* close */
  free (buf); free (buf1)               /* clean up */
.DE
Where <vmeAdrs> is the address to write to in order to fill second
processor's dual ported memory at the correct entry point.
And <target> is the new target directory.
.LP
Execute the script by entering the following to the VxWorks shell on CPU 0:
.DS
    -> <script
.DE
.LP
Now that the executable has been "beamed down", use CPU 1's ROM
monitor to start execution at the entry point.
Although, many ROM monitors provide breakpoints, their use is risky.
VxWorks tinkers with the status register and trap vectors in its early
life which confuses most ROM monitors.
.LP
If it doesn't work the first time, the following tactic may help.
Liberally insert the following `sprintf' line throughout
sysHwInit, usrInit and usrRoot, in order to trace VxWorks' execution.
First initialize the global variable `dbmsg' to 0x00800000
.DS
    char *dbmsg = (char *) 0x00800000; /* shared memory address */
    ...
    dbmsg += sprintf (dbmsg, "In file %s, at line %d.", __FILE__,  __LINE__);
    ...
    /* repeat as necessary */
.DE
The symbols `__FILE__' and `__LINE__' are generated by the C preprocessor.
Recompile and try again.
Examine the debug messages printed to the shared memory by using
the `d' command from CPU 0.
Repeat these steps until the shell comes up.
.LP
VxWorks goes through these routines in order:
sysInit, usrInit, sysHwInit, and usrRoot (multitasking!).
The routines usrInit, and usrRoot are contained in config/all/usrConfig.c.
They in turn call routines which are in vw/config/<target>/ sysLib.c and
tyCoDrv.c.
The stand-alone version of VxWorks,
`vxWorks.st' does not need clock interrupts to boot,
so if clock interrupts seem to be causing trouble,
comment out the clock related calls in usrRoot.
The network will need the system clock.

.N 1 "DEBUGGING THE NETWORK"
.LP
Once the shell is up, test the frequency of the clock and make sure that
timings are `real' time, then test the auxiliary clock if there is one.
Finally, check all the other routines for correctness.
.LP
Next try to bring up the network by doing the following:
.DS
    -> bootline = "bootdev(0,0)hostName:bootfile h=hostInet e=ourInet u=user"
    -> sp usrNetInit, bootline
.DE
Where `bootdev' is the boot device, eg. "enp".  And `bootfile' is the
file on the UNIX host, eg. "/usr/john/vw/config/<target>/vxWorks.st".
The `hostInet' and `ourInet' are the respective ethernet addresses.
Chances are the network will blow up with bus errors.
Check `sysBusToLocal' and `sysLocalToBus' routines for orthodoxy.
The first routine is used by the backplane driver,
the latter, by some network drivers (eg. Excelan).
Also, check that the board jumpering agrees with `config.h'
and possibly `configAll.h'.
.LP
Once the ethernet works, start on the backplane driver.
Try to bring up the new VxWorks with the backplane driver.
CPU 0 should be booted with a backplane number that is a gateway address.
On CPU 1 do the following:
.DS
    -> bpAnchor = 0x00800000                   /* shared memory location */
    -> bpattach (0, bpAnchor, 1, 0, 0, 0, 0)   /* proc. 1, use polling */
    -> bad = "57.1"                            /* backplane address */
    -> ifAddrSet ("bp0", bad)                  /* set interface */
.DE
Once the backplane is tested in polling mode, try to use mailboxes and
bus interrupts if the board has these facilities.  The backplane
interrupt types are defined in `if_bp.h'.

.N 1 "BOOTROMS"
.LP
Once the network is up, and VxWorks is reliable and fully functional,
begin working on the bootroms.
Examine `romInit.s' from another port and modify it to suit;
it should be very similar to `sysALib.s'.
Make `bootrom.hex' (Motorola S-Records) and burn some PROMs.
.LP
When they don't work, check the PROMs for correct byte order, etc..
If it's the software, then "make bootrom", and use `relseg' to relocate
it to 0x00801000 (i.e. shared memory location).
Then modify the earlier script and copy this executable to the
shared memory board, and use the debug ROM monitor to start execution.
Remember `romInit.s' will clear memory, which will
probably kill the debug monitor, so beware.
Once more use the `sprintf' trick to debug the code until getting
the bootroms running out of shared memory.
Then burn it into PROM again.
.LP
Once the bootroms are going, go out and eat lunch and then package all the 
source up and send Wind River Systems a `tar' tape
to be incorporated it into the next VxWorks distribution.  
