.WP "Application Note #1" "Wind River Systems" 4.00
.TL
VxWORKS APPLICATION NOTE #1
.sp
VxWorks - Fortran Interface
.WI
.FS
UNIX is a trademark of AT&T Bell Labs
.br
VxWorks is a trademark of Wind River Systems, Inc.
.FE
.N 1 "INTRODUCTION"
.LP
This application note is for users wishing to use Fortran modules with VxWorks.
Fortran users may link to most of the VxWorks C and assembler routines
by simply loading a Fortran executable with the
.Mo vw/lib/vxFort.a
library archive.

.N 1 "CALLING C FUNCTIONS FROM FORTRAN"
.LP
The Fortran programmer should be familiar with the UNIX document:
"A Portable Fortran 77 Compiler".
The Fortran compiler generates an underbar before and after a
symbol name, eg. "_symbol_", whereas the C compiler generates an underbar
before the symbol name only, eg. "_symbol".  This prevents Fortran from
inadvertently invoking C routines which have an incompatible calling
sequence.
.LP
In most UNIX environments
.To cc
and 
.To f77
have corresponding options.
Options used with 
.To cc
when making a VxWorks executable likewise apply for 
.To f77 .
The library archive
.Mo vw/lib/vxFort.a
contains C interface routines, or wrappers, suitable
for linking a Fortran program into VxWorks \(dg.
.FS
\(dg The ISI Green Hills F77 compiler "knows" about standard math
functions, such as sin, cos, tan, etc..  It makes direct
calls to the C functions, with the correct argument mechanism.
.FE
.LP
Fortran does not support variable number of arguments.
All Fortran calls should place exactly 5 arguments where
a variable number of arguments would be allowed in C.
For example,
.To printf
must be called with 6 arguments.
Strings cannot be passed when they would be in a variable argument
list because the necessary conversions cannot take place.
DOUBLE PRECISION and REAL arguments take two argument positions.
.LP
By default Fortran subroutines are non-reentrant, the storage
class AUTOMATIC should be used with all variables.

.N 1 "GENERATION OF C INTERFACES"
.LP
The C interface routines were automatically generated by the tool
.To f2cgen
from VxWorks C (and assembler) source.
Additional C interfaces for modules may be generated using the provided script
from C source that is formatted in WRS-style.
Due to the automatic nature of the code generation,
it is possible for errors to occur; successful compilation is a good sign.
Routines that require structures, structure pointers, and arrays,
are not usable from Fortran.

.N 1 "CALLING FORTRAN FUNCTIONS FROM THE VxWORKS SHELL"
.LP
When referencing Fortran functions and variables from the shell,
the names have a leading and trailing underbar.  When calling
a Fortran function, or subroutine, the arguments should be 
addresses because of the Fortran call-by-reference scheme.
The following example is of a mindless Fortran subroutine,
.Mo f1sub ,
which has an integer argument, uses the DOUBLE PRECISION function
.Mo cos ,
and call's
.Mo printf .
.DS
-> xx = 1
value = 1
-> _f1sub_, &xx
cos (1) = .540302
->
.DE
.N 1 "EXAMPLE: FORTRAN WITH DBXWORKS"
.LP
To compile a Fortran routine use the following flags:
.DS
-U to preserve upper case
-g for dbxtool
-c for .o

% f77 -U -g -c f.f
.DE
To link with VxWorks Fortran interface library:
.DS
% ld -o f -r f.o /usr/vw/lib/68020/vxFort.a
.DE
To load into vxWorks from shell
.DS
-> ld <xxx
.DE
To call program with 1 integer argument:
.DS
-> i_arg = 10;	/* set value of argument */
-> f1_ (&i_arg)	/* Fortran is always "call by reference" */
.DE
To call program with 1 string argument:
.DS
-> str_arg = "jerome";  /* set value of argument */
-> f2_ (&str_arg, 7)    /* Fortran is always "call by reference" */
                        /* must be given length of string */
.DE
To invoke with dbxtool:
.DS
(dbxtool) func F0
(dbxtool) run F0_ arg1 arg2
.DE
Fortran functions cannot be called with constants you must
use a variable (created in VxWorks shell).
Dbxworks seems to know a little about .f files but still
must be told to invoke the function with a trailing "_".
.DS
C SAMPLE FORTRAN PROGRAM
C
	SUBROUTINE F0 (IARG, DELAY)
	INTEGER IARG, DELAY
C
C       CALL SOME VXWORKS C ROUTINES
C
	CALL taskDelay (delay)
	CALL printf ("HELLO %d\n", IARG)
	END
.DE
