.TH rtcp 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rtcp.c - copy RT-11 and/or UNIX files 
.SH SYNOPSIS
rtcp [-b <b/s>] [-s <s/t>] [-t <t/d>] [-i r|u] [-r] file

rtcp [-b <b/s>] [-s <s/t>] [-t <t/d>] [-i r|u] [-o r|u] [-r] file1 file2

rtcp [-b <b/s>] [-s <s/t>] [-t <t/d>] [-i r|u] [-r] file1 directory

rtcp [-b <b/s>] [-s <s/t>] [-t <t/d>] [-i r|u] [-r] file1 ... directory

.SH DESCRIPTION
This program copies RT-11 or UNIX files onto RT-11 or UNIX files.
With one argument, the file is copied to the standard output.
With two arguments, file1 is copied onto file2; or into directory, retaining
original name.
With three or more arguments, the last argument is assumed to be a directory,
and the files are copied into the directory, retaining their original names.

By default, rtcp assumes that any "normal" UNIX file is, indeed, a UNIX
file, and that any special block-structured device file is an RT-11 device.
The file types of the input and output files can be set explicitly with
the -o and -i switch.  The -r flag turns off the usual rt11 interleave.

The options -b, -s, and -t define the number of bytes per sector, sectors
per track, and tracks per disk on the RT-11 device.  These default to
128, 26, and 77 respectively, which are the right numbers for normal
single density 8" floppy.

Rtcp refuses to copy a UNIX file onto itself.

.SH EXAMPLES
.CS
    rtcp /dev/rt11/gronk.xxx
.CE
copies gronk.xxx on RT-11 volume on /dev/rt11 to stdout.
.CS
    rtcp gronk.c /dev/rt11/honk.c
.CE
copies gronk.c in current directory onto honk.c on RT-11 volume on /dev/rt11.
.CS
    rtcp /dev/rt11/gronk.c /dev/rt11/honk.c
.CE
copies gronk.c on RT-11 volume on /dev/rt11 onto honk.c on same volume.
.CS
    rtcp *.c /dev/rt11
.CE
copies all .c files in the current directory into RT-11 volume on /dev/rt11, with
their original filenames.
.CS
    rtcp -b 512 -s 15 /dev/fd.dd.8/gronk.c
.CE
copies gronk.c from a double density 8" floppy in RT-11 format to stdout.
.CS
    rtcp -b 512 -s 9 -t 35 /dev/fd.dd.5/gronk.c
.CE
copies gronk.c from a double density 5 1/4" floppy in RT-11 format to stdout.
.CS
    rtcp dave.c jerry.c
.CE
copies UNIX file dave.c to UNIX file jerry.c, exactly like UNIX's 'cp'.
.CS
    rtcp -o r dave.c jerry
.CE
copies UNIX file dave.c to file jerry, which is an image of an RT-11 device.

.SH DEFICIENCIES AND WEIRDNESSES
Since expansion of filenames (such as "*.c" to "gronk.c honk.c zonk.c") is done
by the shell, and the shell doesn't know how to find filenames in /dev/rt11,
all RT-11 file names must be fully typed out. A fully functional rtcp should be
able to handle a wild card mechanism, although the shell prevents the use of
the character '*' as that mechanism.

Rtcp allows copying of an RT-11 file onto itself, with destructive consequences.

You can't read or write a real RT-11 double density disk that is usable on
a DEC machine, since there's not enough options to describe such a disk.
Single density works fine, though.

.SH SEE ALSO
"Cross Development", rtinit(4), rtls(4), rt11Lib(1)
