.TH picture 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
picture.c - routines to present target configuration graphically 
.SH DESCRIPTION
This module contains the primitives required to show
board jumpering with the tool jump (4).
The following routines may be used in drawBoard,
defined in the target specific "pic_cpu.c".
.CS
    VOID printAt (pic, x, y, string)
    VOID jumperAt (pic, x, y, len, orient, type, contents)

.CE
Where
.CS
    len      - the number of jumpers in the block.
    contents - the configuration of the jumpers in the jumper block,
.CE
the order and meaning of the bits defined by orient and type as described below
.CS
    orient   - the orientation of the jumper block
                 HORIZONTAL  : LSB of contents is rightmost jumper.
                 VERTICAL    : LSB of contents is bottom jumper.
    type     - the type of the individual jumpers in the jumper block
                 HORIZONTAL  : 0 = removed, 1 = installed
                 VERTICAL    : 0 = removed, 1 = installed
                 HORIZONTAL_3: 0 = right, 1 = left
                 VERTICAL_3  : 0 = down, 1 = up

.CE
.SH SEE ALSO
jump (4)
