.TH mitToMot 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
mitToMot - convert mit format assembler to motorola format
.SH SYNOPSIS
mitToMot [files...]

.SH DESCRIPTION
This script reads the specified files (or standard input if no files
are specified) as MIT format assembly language and writes to standard output
the corresponding Motorola format assembly language.

The following transformations are made:

   Op-code:
      <op>[bwl] -> <op>.[bwl]
      dbra      -> dbf

   Operand:
      0x<n>    -> $<n>
      a0@(<n>) -> <n>(a0)
      a0@+     -> (a0)+
      a0@-     -> -(a0)
      a0@      -> (a0)
      cc       -> ccr
      all spaces are removed from operand field

   Assembler directives:
      .byte    -> dc.b
      .word    -> dc.w
      .int     -> dc.l
      .long    -> dc.l
      .asciz   -> dc.b
      .text    -> section 9
      .bss     -> section 13
      .data    -> section 14
      .align   ->
      .even    ->

