.TH imToBsd 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
imToBsd - Intermetrics to UNIX BSD 4.3 a.out object module converter 
.SH SYNOPSIS
imToBsd [-x n] [-v] [-u] [-t textAdrs] [-d dataAdrs] [-b bssAdrs] [-e entryAdrs]
        [-o outfile] [-s symfile] <file>

.SH DESCRIPTION
imToBsd converts Intermetrics object modules to UNIX BSD 4.2/4.3 a.out
format object modules.  The resulting object module retains all the relocation
and symbol table information of the original.  The converted object module
is written to a file with the same base name as the original but with a
suffix of ".ob", unless the -o flag is used to specify another name.

.SH RELOCATION
imToBsd can process both relocatable object modules produced by the
Intermetrics assembler or linker, or absolute object modules produced by
the Intermetrics locator.
imToBsd is also capable of performing the relocations itself with the
-t, -d, and -b flags.  In most cases, this eliminates the need for the
Intermetrics locator in generating absolute modules.  This saves a pass
over the object module and simplifies the syntax in generating absolute
modules (the Intermetrics locator having a flexible but cumbersome syntax).
Thus typical sequences of generating a.out format object modules from
Intermetrics tools are:

 compiler -> assembler -> imToBsd => RELOCATABLE OBJECT MODULE
 compiler -> assembler -> linker -> imToBsd => RELOCATABLE OBJECT MODULE
 compiler -> assembler -> linker -> locator -> imToBsd => ABSOLUTE OBJECT MODULE
 compiler -> assembler -> linker -> imToBsd -t... => ABSOLUTE OBJECT MODULE

.SH UNIX SYMBOLS
The UNIX linker/loader will automatically define the symbols `etext', `edata',
and `end' as the end of the text segment, data segment,
and bss segments respectively.
imToBsd will define these symbols if the -u flag is specified.
This is only meaningful if an absolute object module is being generated.

.SH SYMBOL TABLE ONLY MODULE
The VxWorks booting process requires a module that contains just the symbol
table of the system image being booted.  This module is read when the
system is started in order to initialize the system symbol table.
VxWorks includes another tool, `xsym', that extracts the symbol table
from an absolute object module.  However, imToBsd can generate the symbol
table module directly by specifying the -s flag with the desired name of the
symbol table module.

.SH OPTIONS
  -x  n      debug bits:
               0x01 = print each lex item scanned
               0x02 = print yacc state transitions
  -v         verbose - print message for each conversion step
  -u         UNIX symbols - define symbols `etext', `edata', and `end'
               the way UNIX compilers do, as end of text segment,
               end of data segment, and end of bss respectively.
               These  symbols are meaningful only if -t, -d,
               and/or -b are specified.
  -t adrs    locate text segment at specified adrs
  -d adrs    locate data segment at specified adrs
               (default = immediately following text segment).
  -b adrs    locate bss segment at specified adrs
               (default = immediately following data segment).
  -e adrs    set entry address to specified adrs
               (default = start of text segment).
  -o file    output BSD format object module to specified file
               (default = input filename with .ob suffix).
  -s file    generate symbol-table-only module for use in
               downloading vxWorks system image to specified file
               (i.e. vxWorks.sym).

.SH EXAMPLES
The following converts an application module that has been compiled and
assembled into an a.out format module suitable for downloading to VxWorks
with the VxWorks loader (ld).

    imToBsd test.o

The following converts a completely linked VxWorks system image that has
been compiled, assembled, and linked, into an a.out format module suitable
for downloading to the VxWorks boot roms.  It performs the relocations necessary
to locate the code starting at 0x1000.  It also generates the required
vxWorks.sym symbol table module.

    imToBsd -v -u -t 1000 -o vxWorks -s vxWorks.sym vxWorks.o

.SH DEFICIENCIES
The full expression syntax in Intermetrics object modules includes possibly
complex expressions with several arithmetric operators.
However, with the Green Hills compiler/Intermetrics assembler we use,
the only expressions we've encountered are constant values,
constant offsets from an id (i.e. <id> + offset),
and, in a few of the library routines,
a difference of two offsets from the same segment
(i.e. (<seg1> + offset1) - (<seg1> + offset2)) which obviously reduces to
a constant.
imToBsd is currently capable of handling only these forms of expressions.
Anything more elaborate will be reported as an error and imToBsd will fail.

.SH SEE ALSO
UNIX BSD 4.3 a.out documentation,
Intermetrics Object Module Definition
