.TH 3x4 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
3x4 - 3.2 to 4.0 conversion script
.SH SYNOPSIS
3x4 file [...]

.SH DESCRIPTION
This tool converts, or marks, routines differing in calling
sequence and/or naming conventions from VxWorks 3.2 to VxWorks 4.0.

A routine that has had only a name change is simply
replaced with the new name.
A routine that has had a parameter list change is replaced
with "##", the new/same name, the new parameter list, "##",
and the old parameter list.
The "##"'s are inserted to cause compiler errors flagging routines
which cannot be automatically converted.

This script has 5 parts.  The Bourne shell section at the
beginning, followed by 4 sed scripts, followed by a text table
of name transformations (provided solely for informational
purposes).

.SH EXAMPLE

    % 3x4 test.c
    3x4: processing test.c
    % diff test.c test.c.3x4
    4,7c4,7
    <     vxTdelay (60);
    <     printStatus (0);
    <     iosFdSet (fd,drvnum,name,value);
    <     vxDelTaskVar (pVar);
    ---
    >     taskDelay (60);
    >     printErrno (0);
    >     ##iosFdSet(fd,pDevHdr,name,value)## (fd,drvnum,name,value);
    >     ##taskVarDelete(tskId,pVar)## (pVar);
    %     

.SH SEE ALSO
3x4Lib (2), 3x4ALib (2)

.SH FILES
 file.3x4     output file
 /tmp/3x4.*   intermediate 'sed' files

