.TH tyC16Drv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
tyC16Drv.c - The microbar COM16 serial i/o tty handler 
.SH SYNOPSIS
.nf
tyC16Drv - install COM16 serial i/o tty driver
tyC16DevCreate - create a device for a COM16 port
handleInt - deal with com16 interrupt

STATUS tyC16Drv (ioBase, intVector, intLevel)
STATUS tyC16DevCreate (name, channel, rbSize, wbSize, baudRate)
VOID handleInt (pCtrl)
.fi
.SH DESCRIPTION
This is the driver for the Microbar COM16 serial controller board.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly: tyC16Drv () to
initialize the driver, and tyC16DevCreate () to create devices.

.SH TYC16DRV
Before using the driver, it must be initialized by calling the routine:
.CS
 STATUS tyC16Drv (ioBase, intVector, intLevel)
     UTINY *ioBase;             /* base i/o address *
     FUNCPTR *intVector;        /* base interrupt vector *
     int intLevel;              /* interrupt level *
.CE
The first time tyC16DRV is called, it will install board number 0,
the second time board number 1, and so on up to N_COM16_BOARDS.
The status returned is OK, or ERROR if non-existent hardware or it
ran out of memory.

This routine should be called exactly once, before any reads, writes, or
tyC16DevCreates.  Normally, it is called from usrRoot (2) in usrConfig.c.

.SH CREATING TERMINAL DEVICES
Before a terminal can be used, it must be created.  This is done
with the tyC16DevCreate call.
Each port to be used should have exactly one device associated with it,
by calling this routine.

.CS
 STATUS tyC16DevCreate (name, channel, rdBufSize, wBufSize, baudRate)
     char *name;     /* Name to use for this device *
     int channel;    /* encoded COM16 port number of device;
                      * upper word is board number,
                      * lower word is line number *
     int rdBufSize;  /* Read buffer size, in bytes *
     int wBufSize;   /* Write buffer size, in bytes *
     int baudRate;   /* Baud rate to create device with *
.CE

For instance, to create the device "/ty/0", with buffer sizes of 512 bytes,
at 9600 baud, the proper call would be:
.CS
   tyC16DevCreate ("/ty/0", 0, 512, 512, 9600);
.CE
.SH IOCTL
This driver responds to all the same ioctl codes as a normal ty driver.
All baud rates between 50 and 56000 are available.
