.TH ptyDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ptyDrv.c - pseudo terminal driver 
.SH SYNOPSIS
.nf
ptyDrv - pseudo-terminal driver
ptyDevCreate - create a master/slave pair

STATUS ptyDrv ()
STATUS ptyDevCreate (name, rdBufSize, wrtBufSize)
.fi
.SH DESCRIPTION
The pseudo terminal driver is used to provide a tty-like interface between
two processes; one process acts as a master, and simulates the 'hardware' side
of the driver (i.e. a USART), while the other process acts as the slave, which
is the normal application program that ordinarily talks to the driver.
It is used primarily in network applications.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, ptyDrv () to
initialize the driver, and ptyDevCreate () to create devices.

.SH PTYDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    ptyDrv ()
.CE
This routine must be called before any reads, writes, or
ptyDevCreates.  Normally, it is called from usrRoot (2) in usrConfig.c.

.SH CREATING PSEUDO-TERMINAL DEVICES
Before a pseudo-terminal can be used, it must be created.  This is done
with the ptyDevCreate call:

.CS
    STATUS ptyDevCreate (name, rdBufSize, wrtBufSize)
        char *name;             /* name of pseudo-terminal *
        int rdBufSize;          /* size of terminal read buffer *
        int wrtBufSize;         /* size of write buffer *
.CE

For instance, to create the device pair "/pty/0.M" and "/pty/0.S",
with read and write buffer sizes of 512 bytes, the proper call would be:
.CS
   ptyDevCreate ("/pty/0.", 512, 512);
.CE
When ptyDevCreate is called, two devices are created (the master
and slave device), one called nameM and the other called nameS,
which may then be opened by the master and slave processes.
Data written to the master
device may then be read on the slave device, and vice versa.  Ioctl calls
may be made either to the master or slave device, but keep in mind that they
are really one device (for aesthetic reasons, you should really only apply
them to the slave side).

.SH IOCTL
The pty driver responds to all the same ioctl codes as a normal tty driver.
