.TH pipeDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
pipeDrv.c - pipe I/O driver 
.SH SYNOPSIS
.nf
pipeDrv - pipe driver main routine
pipeDevCreate - create a pipe device

STATUS pipeDrv ()
STATUS pipeDevCreate (name, nMessages, nBytes)
.fi
.SH DESCRIPTION
This is the pipe driver.  It allows I/O to be performed between tasks
similarly to the way it is performed to devices, via constructs
known as pipes.  Pipes are created and given names (with pipeDevCreate) and
can then be read and written with normal read and write calls.

The main difference between pipes and device I/O is that pipe I/O is done in
discrete units, known as messages.  All the data written as a single write
call is kept together, and will all be read by a single read call.  In
the same way, a read call will read only the number of bytes which were
written to the message being read, even though there may be more messages
in the pipe waiting to be read.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, ptyDrv () to
initialize the driver, and ptyDevCreate () to create devices.
 
.SH PIPEDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    pipeDrv ()
.CE
This routine must be called before any reads, writes, or
pipeDevCreates.  Normally, it is called from usrRoot (2) in usrConfig (1).
 
.SH CREATING PIPES
Before a pipe can be used, it must be created.  This is done
with the pipeDevCreate call:
.CS
STATUS pipeDevCreate (name, nMessages, nBytes)
    char *name;      /* name of pipe to be created      *
    int nMessages;   /* max. number of messages in pipe *
    int nBytes;      /* size of each message            *
.CE
For instance, to create the device pipe "/pipe/demo",
with up to 10 messages of size 100 bytes, the proper call would be:
.CS
   pipeDevCreate ("/pipe/demo", 10, 100);
.CE
This device can now be opened, read, and written to;
creating and closing are not applicable.
 
.SH IOCTL
The pipe driver ioctl call responds to the following ioctl codes.
.CS
    FIONREAD    - return the total number of bytes in the
                  pipe, in the variable pointed to by
                  argument.

    FIONMSGS    - return the number of discrete messages
                  available to be read in the pipe, in
                  the variable pointed to by argument.

    FIOFLUSH    - discard all messages in the pipe.
.CE

.SH SEE ALSO
"I/O System"
