.TH nfsDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
nfsDrv.c - Network File System I/O driver 
.SH SYNOPSIS
.nf
nfsDrv - NFS driver installation
nfsMount - mount an NFS directory
nfsDevShow - display all mounted NFS devices
nfsUnmount - unmount an NFS device

STATUS nfsDrv ()
STATUS nfsMount (host, fileSystem, localName)
VOID nfsDevShow ()
STATUS nfsUnmount (localName)
.fi
.SH DESCRIPTION
The driver nfsDrv provides a facility for accessing files transparently
over the network via NFS.
By creating a network device with nfsMount, files on a remote
NFS system, such as a UNIX system, may be handled as if they are local.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Three routines, however, must be called directly: nfsDrv () to
initialize the driver, nfsMount() to mount file systems, and nfsUnmount()
to unmount them.

.SH NFSDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    nfsDrv ()
.CE
This routine should be called exactly once, before any reads, writes, or
other NFS calls.  Normally, it is called from usrRoot (2) in usrConfig (1).

.SH CREATING NFS DEVICES
In order to access a remote file system, an NFS device must be created.
If there is a UNIX host "wrs" with an NFS mountable disk "/d0",
i.e. "/d0" is listed in the file /etc/exports on "wrs",
then files on "/d0" may be accessed from VxWorks.
The routine nfsMount can be used to create a VxWorks NFS device for "/d0/".
It is defined as follows:
.CS
STATUS nfsMount (host, fileSystem, localName)
    char *host;       /* name of remote host                    *
    char *fileSystem; /* name of remote directory to mount      *
    char *localName;  /* local device name for remote directory *
                      /* (NULL = use fileSystem name)           *
.CE
To create the device, make the call:
.CS
   nfsMount ("wrs", "/d0/", "/myd0/");
.CE
or
.CS
   nfsMount ("wrs", "/d0/", NULL);
.CE
or from the shell, type
.CS
   nfsMount "wrs", "/d0/"
.CE

In the first instance, a device named "/myd0/" will be created via
which a file on the UNIX system "wrs" named "/d0/dog" may now be accessed
as "/myd0/dog".
The third parameter to nfsMount may be NULL, as in the last two instances.
Then, by default, VxWorks will create a device with the same
name as the file system.  In these cases, the device will
be named "/d0/" and the file "/d0/dog" can be accessed by the same name,
"/d0/dog".

The host ("wrs" in this case) must have already been specified with a
hostAdd (2) call.  This may have already been done if VxWorks was booted
from "wrs".

The routine nfsDevShow lists the mounted NFS devices.
.CS
    -> nfsDevShow                     
    device name          file system                                       
    -----------          -----------                                       
    /yuba1/              yuba:/yuba1/                                      
    /wrs1/               wrs:/wrs1                                          
    value = 0 = 0x0
    -> 
.CE

.SH IOCTL
The NFS driver ioctl (2) call responds to the following codes:
.CS
 FIOSEEK  - seek to a byte in the open file, see fseek (2).
 FIOWHERE - return the current byte pointer into the open file.
 FIONREAD - return (in *arg) the number of unread bytes in the file.
.CE

.SH SEE ALSO
nfsLib (1), hostAdd (2), "Network"
