.TH netDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
netDrv.c - network remote file I/O driver 
.SH SYNOPSIS
.nf
netDrv - network remote file driver installation
netDevCreate - create a remote file device

STATUS netDrv ()
STATUS netDevCreate (devName, host, protocol)
.fi
.SH DESCRIPTION
NetDrv provides a device for accessing files transparently over the network.
By creating a network device with netDevCreate, files on a remote UNIX machine
may be accessed exactly like local files.

When a remote file is opened, the entire file is copied over the network to a 
local network file descriptor.  If a remote file is created, an empty local
network file descriptor is opened.  Reads, writes, and ioctl functions are 
done on the local copy of the file.  When the file is closed, if it was opened 
for WRITE or UPDATE and the file has changed, the local copy is sent back over 
the net to the UNIX machine.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, netDrv () to
initialize the driver, and netDevCreate () to create devices.

.SH NETDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    netDrv ()
.CE
This routine should be called exactly once, before any read's, write's, or
netDevCreate's.  Normally, it is called from usrRoot (2) in usrConfig (1).

.SH CREATING NET DEVICES
In order to access a particular computer, a "network device" must
be created for it.
For instance, if there is a UNIX host on the network whose name is "wrs",
files may be used on it by making a device called "wrs:".  The routine
that does this is netDevCreate.  It is defined as follows:

.CS
    STATUS netDevCreate (devName, host, protocol)
        char *devName;  /* name of device to create *
        char *host;     /* host this device will talk to *
        int protocol;   /* remote file access protocol;
                         * 0 = rsh, 1 = ftp *
.CE

For instance, to create the "wrs:" device just discussed, the proper call
would be:
.CS
   netDevCreate ("wrs:", "wrs", 0);
.CE
After creating this device, a file on the UNIX system "wrs" named /usr/dog
may be accessed as "wrs:/usr/dog".

The host ("wrs" in this case) must have already been created
with a hostAdd (2) call.

.SH IOCTL
The net driver ioctl (2) call responds to the following ioctl codes.
.CS
 FIOSEEK  - seek to a byte in the open file, same as lseek (2).
 FIOWHERE - return the current byte pointer into the open file.
 FIONREAD - return (in *arg) the number of unread bytes in the file.
.CE

.SH SEE ALSO
remLib (1), netLib (1), sockLib (1), hostAdd (2)
