.TH tyDevInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
tyDevInit - initialize ty device descriptor
.SH SYNOPSIS
.CS
.nf
STATUS tyDevInit (pTyDev, rdBufSize, wrtBufSize, txStartup)
    TY_DEV_ID pTyDev;  /* pointer to ty device descriptor     */
                       /* to be initialized                   */
    int rdBufSize;     /* required read buffer size in bytes  */
    int wrtBufSize;    /* required write buffer size in bytes */
    FUNCPTR txStartup; /* device transmit startup routine     */
.fi
.CE
.SH DESCRIPTION
This routine initializes a ty device descriptor according to the
specified parameters.  The initialization includes allocating read and
write buffers of the specified sizes from the memory pool, 
and initializing their respective buffer descriptors.
The semaphores are initialized and the write semaphore 'given'
to enable writers.  Also the transmitter startup routine pointer is set
to the specified routine.  All other fields in the descriptor are zeroed.

This routine should only be called by serial drivers.

.SH RETURNS
 OK, or
 ERROR if not enough memory to allocate data structures
.SH SEE ALSO
tyLib(1)
