.TH tt 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
tt - print a stack trace of a task
.SH SYNOPSIS
.CS
.nf
STATUS tt (taskNameOrId)
    int taskNameOrId; /* task whose stack is to be traced */
.fi
.CE
.SH DESCRIPTION
This routine prints a list of the nested routine calls that the specified
task is in.
Each routine call, with its parameters, is shown.
This higher-level symbolic stack trace is built on top of the 
low-level routines provided by the routines in trcLib (1).

If task is missing or zero, the last task referenced is assumed.
tt can only trace the stack of a task other than itself.  For instance,
when tt is called from the shell, it cannot trace the shell's stack.

.SH EXAMPLE
.CS
 -> tt "logTask"
  3ab92 _vxTaskEntry   +10 : _logTask (0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
   ee6e _logTask       +12 : _read (5, 3f8a10, 20)
   d460 _read          +10 : _iosRead (5, 3f8a10, 20)
   e234 _iosRead       +9c : _pipeRead (3fce1c, 3f8a10, 20)
  23978 _pipeRead      +24 : _semTake (3f8b78)              
 value = 0 = 0x0
 -> 
.CE
This indicates that the logTask is currently in semTake (with
1 parameter), which was called by pipeRead (with 3 parameters),
which was called by iosRead (with 3 paramters), and so on.

.SH CAVEAT
In order to do the trace, some assumptions are made.
In general, the trace will work for all C language routines,
and for assembly language routines that start with a LINK instruction.
Some C compilers require specific flags to generate the LINK first.
Most VxWorks assembly language routines include LINK instructions
for exactly this reason.
However, routines written in other languages, strange entries into
routines, or tasks with corrupted stacks, can make the trace very confused.
Also, all parameters are assumed to be 32-bit quantities, so structures
passed as parameters will be displayed as some number of long integers.

.SH RETURNS
  OK, or
  ERROR if task does not exist.

.SH SEE ALSO
dbgLib(1),
"Debugging", trcLib(1), UNIX cc manual entry
