.TH taskVarInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskVarInit - initialize task variables facility
.SH SYNOPSIS
.CS
.nf
STATUS taskVarInit ()
.fi
.CE
.SH DESCRIPTION
This routine initializes the task variables facility.
It installs task switch and delete hooks that are used in implementing
task variables.  If it is not called explicitly, it will automatically
be called by taskVarAdd (2) when the first task variable is added.

After the first invocation of this routine, subsequent invocations
have no affect.

.SH WARNING
There are often order dependencies in task delete hooks involving
task variables.  That is, if a facility uses task variables and has a
task delete hook that expects to use those task variables, then that
facility's delete hook must run before the task variables delete hook.
Otherwise the task variables would have been deleted by the time the
other facility's delete hook ran.  VxWorks is careful to run the
delete hooks in the REVERSE of the order in which they were installed.
So any facility that has a delete hook that will use task variables
can guarantee proper ordering by calling taskVarInit before adding
its own delete hook.

It should be understood that this is not an issue in normal use of
task variables.  The issue only arises when adding another task
delete hook that uses task variables.

.SH RETURNS
OK or ERROR if couldn't install task switch/delete hooks
.SH SEE ALSO
taskVarLib(1)
