.TH taskVarAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskVarAdd - add a task variable to a task
.SH SYNOPSIS
.CS
.nf
STATUS taskVarAdd (tid, pVar)
    int tid;   /* id of task to have new variable */
    int *pVar; /* pointer to variable to be switched for task */
.fi
.CE
.SH DESCRIPTION
This routine adds the specified variable (4 byte memory location)
to the task's context.  After calling this routine, the specified
variable will be "private" to the task.  That task can access
and modify the variable in any way, but its modifications to the
variable will not appear to other tasks, and other tasks' modifications
to that variable will not affect the value seen by the that task.
This is accomplished by saving and restoring the value of that variable
each time a task switch is made to or from the calling task.

This facility can be used when a single routine is to be spawned
repeatedly as several independent tasks.  Although each task
will have its own stack, and thus separate stack variables, they will
all share the same "static" and "global" variables.  To make such a
variable NOT shared, the routine can call taskVarAdd (2), thus
making a separate copy of that variable for each task, but all
at the same physical address.

Note that task variables increase the task switch time to and from
the tasks that own them, so it is desirable to limit the number of
task variables that a task uses.  An efficient use of task variables is
to have a single task variable that is a pointer to a dynamically 
allocated structure containing the task's private data.

.SH EXAMPLE
Suppose three identical tasks were spawn'd with the routine "operator".
They use a structure "OP_GLOBAL" for all variables that are specific
to the particular incarnation of the task.  The following code fragment
shows how this is set up.
.CS
OP_GLOBAL *opGlobal;  /* pointer to operator task's global variables *

operator (opNum)
    int opNum;                /* number of this operator task *
    {
    if (taskVarAdd (0, (int *)&opGlobal) != OK)
        {
        printErr ("operator%d: can't taskVarAdd opGlobal\n", opNum);
        taskSuspend (0);
        }

    if ((opGlobal = (OP_GLOBAL *) malloc (sizeof (OP_GLOBAL))) == NULL)
        {
        printErr ("operator%d: can't malloc opGlobal\n", opNum);
        taskSuspend (0);
        }
    ...
    }
.CE

.SH RETURNS
  OK, or
  ERROR if not enough memory for task variable descriptor.

.SH SEE ALSO
taskVarLib(1),
taskVarDelete(2), taskVarGet(2), taskVarSet(2)
