.TH taskIdDefault 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskIdDefault - default task id
.SH SYNOPSIS
.CS
.nf
int taskIdDefault (tid)
    int tid; /* user supplied task id, if 0 then just return default */
.fi
.CE
.SH DESCRIPTION
This routine maintains a global default task id.  This id is used by 
libraries that want to allow a task id argument to take on a default
value if the user did not explicitly supply one.
If the task id supplied to this routine is not zero (i.e. the user
did specify a taskId) then the default id is set to that value,
and that value is returned.  If the task id supplied to this routine
is zero (i.e. the user did not specify a task id) then the default id
is not changed and its value is returned.  Thus the value returned
is always the last task id the user specified.

.SH RETURNS
most recently set non-zero task id

.SH SEE ALSO
taskLib(1),
dbgLib (1), "Debugging"
