.TH symEach 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
symEach - call a routine for each entry in a symbol table
.SH SYNOPSIS
.CS
.nf
VOID symEach (pTbl, routine, routineArg)
    SYMTAB *pTbl;    /* pointer to symbol table                  */
    FUNCPTR routine; /* the routine to call for each table entry */
    int routineArg;  /* arbitrary user-supplied argument         */
.fi
.CE
.SH DESCRIPTION
This routine calls a user-supplied routine once for each entry in the
symbol table.  The routine should be declared as follows:
.CS
 BOOL routine (name, val, type, arg)
     char *name;   /* entry name                       *
     int val;      /* value associated with the entry  *
     UTINY type;   /* entry type                       *
     int arg;      /* arbitrary user-supplied argument *
.CE
The user-supplied routine should return TRUE if symEach is to continue
calling it for each entry, or FALSE if it is done and symEach can exit.

.SH SEE ALSO
symLib(1)
