.TH select 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
select - pend on a set of file descriptors
.SH SYNOPSIS
.CS
.nf
int select (width, pReadFds, pWriteFds, pExceptFds, pTimeOut)
    int width;                /* number of bits to examine from 0 */
    fd_set *pReadFds;         /* read file descriptors */
    fd_set *pWriteFds;        /* write file descriptors */
    fd_set *pExceptFds;       /* exception file descriptors */
    struct timeval *pTimeOut; /* maximum time to wait for activity; */
                              /* NULL to poll forever */
.fi
.CE
.SH DESCRIPTION
Poll the set of fd's and then delay.
The length of the delay can be specified with selectDelaySet (2).
The parameter `width' specifies the first fd's to test in the sets.
The 3 fd sets are bit arrays corresponding to the open file
descriptors to test.
If the `pTimeout' value is NULL then select blocks indefinitely.

The I/O system currently does not contain the facilities
needed to implement UNIX style select, which essentially pends a
task until activity on a set of file descriptors is detected.  
However, this routine provides a rough functional equivalent. 

.SH WARNING
  Currently, may only be used with fd's of sockets.
  Currently, only examines the `pReadFds'. 

.SH MACROS
The following macros are available for setting the appropriate bits
in the fd_set structure:
.CS
 FD_SET(fd,&fdset)
 FD_CLR(fd,&fdset)
 FD_ISSET(fd,&fdset)
 FD_ZERO(&fdset)
.CE

.SH RETURNS
number of file descriptors with activity, or 0 if timed out

.SH SEE ALSO
sockLib(1),
selectDelaySet (2)
