.TH ramDevCreate 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ramDevCreate - create a ram disk device
.SH SYNOPSIS
.CS
.nf
STATUS ramDevCreate (name, where, bytesSec, secTrack, nSectors,
                rtFmt, secOffset)
    char *name;    /* Device name                          */
    char *where;   /* Where it is in memory (0 = malloc)   */
    int bytesSec;  /* Number of bytes per sector           */
    int secTrack;  /* Number of sectors per track          */
    int nSectors;  /* Number of sectors on this device     */
    BOOL rtFmt;    /* True if RT-11 skew and intereleave   */
    int secOffset; /* Number of sectors to skip at         */
                   /* beginning of physical device         */
.fi
.CE
.SH DESCRIPTION
This routine creates a ram disk device.
The memory for the ram disk may be allocated separately by providing `where'
or, if the `where' parameter is NULL then memory will be automatically
allocated.

The formatting parameters (bytesSec, secTrack, nSectors, rtFmt) are critical
only if the ramdisk memory already
contains an image of a disk, created elsewhere.  In that case, the
formatting parameters must be identical to those used when the image
was created.  Otherwise, they may be any convenient number.
In this case, 512 is a good sector size,
secTrack could be == nSectors, rtFmt could be FALSE, and secOffset == 0.

.SH RETURNS
OK | ERROR if out of memory or I/O system unable to add device
.SH SEE ALSO
ramDrv(3)
