.TH pipeDevCreate 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
pipeDevCreate - create a pipe device
.SH SYNOPSIS
.CS
.nf
STATUS pipeDevCreate (name, nMessages, nBytes)
    char *name;        /* name of pipe to be created      */
    int nMessages;     /* max. number of messages in pipe */
    int nBytes;        /* size of each message            */
.fi
.CE
.SH DESCRIPTION
This routine is called once for each pipe to be created.
It allocates the various structures necessary, and initializes the device.
The pipe will have a maximum of `nMessages' messages in the pipe at once.
When the the pipe is full, a task attempting to write to the pipe
will be suspended until a message has been read.  If the pipe is written
to at interrupt level, and is full, then that message is lost.

.SH RETURNS
OK or ERROR
.SH SEE ALSO
pipeDrv(3)
