.TH open 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
open - open a file
.SH SYNOPSIS
.CS
.nf
int open (name, flags, mode)
    char *name;        /* name of the file to open        */
    int flags;         /* READ, WRITE, UPDATE, or O_CREAT */
    int mode;          /* mode of file to be created      */
                       /* (UNIX chmod style)              */
.fi
.CE
.SH DESCRIPTION
Open the file for reading, writing, or updating (reading and writing)
as specified by the flags argument, and returns a descriptor for that file.
The flags argument may indicate that the file is to be created if it does not 
already exist (by specifying the O_CREAT flag), in which case the file is
created with mode `mode' as described in UNIX chmod (2).  However only the
NFS driver makes use of the `mode' argument.

The `flags' value is constructed by or'ing the following:
(only one of the first three below may be used):

      READ    (or O_RDONLY)   open for reading only
      WRITE   (or O_WRONLY)   open for writing only
      UPDATE  (or O_RDWR)     open for reading and writing
      O_CREAT                 create a new file

.SH RETURNS
   File descriptor number, or
   ERROR if no filename specified,
            no such device,
            no more fd's (see iosInit (2)),
            or driver returns ERROR.

.SH SEE ALSO
ioLib(1),
"I/O System"

