.TH lseek 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
lseek - set file read/write pointer
.SH SYNOPSIS
.CS
.nf
int lseek (fd, offset, whence)
    int fd;             /* file descriptor            */
    long offset;        /* new byte offset to seek to */
    int whence;         /* relative file position     */
.fi
.CE
.SH DESCRIPTION
Sets the file read/write pointer of file 'fd' to 'offset'.
The `whence' has three values which affect the file position pointer:

     L_SET  - set to `offset',
     L_INCR - set to current position plus `offset',
     L_XTND - set to the size of the file plus `offset'.

This routine uses ioctl (2) with functions FIOWHERE and FIOSEEK.

.SH RETURNS
   the new offset from the beginning of the file, or ERROR

.SH SEE ALSO
ioLib(1)
