.TH logMsg 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
logMsg - log formatted error message
.SH SYNOPSIS
.CS
.nf
VOID logMsg (fmt, arg1, arg2, arg3, arg4, arg5, arg6)
    char *fmt;  /* format string for print */
    int arg1;   /* optional arguments for fmt */
    int arg2;
    int arg3;
    int arg4;
    int arg5;
    int arg6;
.fi
.CE
.SH DESCRIPTION
This routine logs the specified message via the logging task.
The arguments to the routine are identical to printf (2):
a format string followed by arguments to be filled in the format.
However, logMsg (2) is restricted to a maximum of 6 arguments following
the format string.

The task id of the caller will be prepended to the specified message.

.SH EXAMPLE

If the following code were executed by task 20:

  {
  name = "GRONK";
  num = 123;

  logMsg ("ERROR - name = %s, num = %d.\\n", name, num);
  }

then the following error message would appear on the system log:

t20: ERROR - name = GRONK, num = 123.

.SH SEE ALSO
logLib(1),
printf(2)
