.TH kernelInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
kernelInit - initialize kernel
.SH SYNOPSIS
.CS
.nf
VOID kernelInit (trapNum, rootRtn, rootStackSize, memPoolStart,
         memPoolEnd, intStackSize, lockOutLevel)
    int trapNum;        /* kernel trap number             */
    FUNCPTR rootRtn;    /* user startup routine           */
    int rootStackSize;  /* stack size for startup routine */
    char *memPoolStart; /* beginning of memory            */
    char *memPoolEnd;   /* end of memory                  */
    int intStackSize;   /* interrupt stack size           */
    int lockOutLevel;   /* interrupt lock out level (1-7) */
.fi
.CE
.SH DESCRIPTION
This routine initializes and starts the kernel.  It should only be called
once.  The routine `rootRtn' is the user's startup code that subsequently
installs system facilities (eg. initialize the I/O system),
spawns tasks, etc..

.SH SEE ALSO
kernelLib(1)
