.TH intLock 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
intLock - lock out interrupts
.SH SYNOPSIS
.CS
.nf
int intLock ()
.fi
.CE
.SH DESCRIPTION
This routine is used to disable interrupts.  The interrupt level is
set to the lock-out level (level 7 by default).  The routine returns
the previous interrupt level, and this should be restored by a call
to intUnlock (2).

.SH IMPORTANT CAVEAT
intLock can be called both from interrupt level and from task level.
When called from a task context, the interrupt lock level is part
of the task's context.  Locking out interrupts does not prevent rescheduling.
Thus, if a task locks out interrupts and then invokes kernel services that
cause the task to block (e.g. taskSuspend (2) or taskDelay (2)) or
causes a higher priority task to be ready
(e.g. semGive (2) or taskResume (2)), then rescheduling will
occur and interrupts will be unlocked while other tasks run.
Rescheduling may be explicitly disabled with taskLock (2).

.SH EXAMPLE
.CS
 oldLevel = intLock ();
 /* ...work with interrupts locked out... *
 intUnlock (oldLevel);
.CE

.SH RETURNS
previous interrupt level

.SH SEE ALSO
intLib(1),
intUnlock (2), taskLock (2)
