.TH intHandlerCreate 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
intHandlerCreate - construct interrupt handler for C routine
.SH SYNOPSIS
.CS
.nf
FUNCPTR intHandlerCreate (routine, parameter)
    FUNCPTR routine; /* routine to be called */
    int parameter;   /* parameter to be passed to routine */
.fi
.CE
.SH DESCRIPTION
This routine builds an interrupt handler around the specified C routine.
This interrupt handler is then suitable for connecting to a
specific vector address with intVecSet (2).
The routine will be invoked in supervisor mode at interrupt level.
A proper C environment will have been established,
the necessary registers saved, and the stack set up.

The routine can be any normal C code, except that it must not
invoke certain operating system functions.

.SH IMPLEMENTATION
This routine builds an interrupt handler of the following form in
allocated memory.

.CS
 0x00  4EB9 kkkk kkkk jsr     _intEnt           * tell kernel
 0x06  48E7 E0C0      movem.l d0-d2/a0-a1,-(a7) * save regs
 0x0a  2F3C pppp pppp move.l  #parameter,-(a7)  * push param
 0x10  4EB9 rrrr rrrr jsr     routine           * call C routine
 0x16  588F           addq.l  #4,a7             * pop param
 0x18  4CDF 0307      movem.l (a7)+,d0-d2/a0-a1 * restore regs
 0x1c  4EF9 kkkk kkkk jmp     _intExit          * exit via kernel
.CE

.SH RETURNS
   pointer to new interrupt handler, or
   NULL if out of memory
.SH SEE ALSO
intLib(1)
