.TH ifBroadcastSet 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ifBroadcastSet - set broadcast address for an interface
.SH SYNOPSIS
.CS
.nf
STATUS ifBroadcastSet (interfaceName, broadcastAddress)
    char *interfaceName;    /* Name of interface to assign */
    char *broadcastAddress; /* Broadcast adrs to assign to interface */
.fi
.CE
.SH DESCRIPTION
ifBroadcastSet is used to change the broadcast address for a particular
interface.
The named interface (supplied in the first parameter, eg "ex0" or "bp0")
is assigned the broadcast address supplied in the second parameter, which
must be a string in standard internet address format (eg "90.0.0.0"). 

The default broadcast address for an interface is the interface's inet
address with a host part of all 1's (eg. "90.255.255.255").
This conforms to current ARPA specifications.
However, some older implementations of the Internet
protocols use a host part of all 0's for the broadcast address.
The VxWorks implementation will automatically receive a host part of 
all 0's as a broadcast address, in addition to the default or specified
broadcast address.  But if VxWorks is to broadcast to older systems
using a host part of all 0's as the broadcast address, then this
routine should be used to change the broadcast address of the interface.

.SH RETURNS
OK | ERROR
.SH SEE ALSO
ifLib(1)
